/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server;

import app.figma.server.Constants;
import app.figma.server.Figma;
import app.figma.server.FigmaHelper;
import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.dto.FigmaMetadataDTO;
import app.figma.server.api.v100000000.dto.FigmaUserDTO;
import app.figma.server.api.v100000000.dto.FigmaVersionDTO;
import app.figma.server.api.v100000000.dto.LinkDTO;
import app.figma.server.api.v100000000.dto.PageDTO;
import app.figma.server.api.v100000000.dto.UserDTO;
import app.figma.server.api.v100000000.dto.ViewDTO;
import app.figma.server.api.v100000000.helpers.Page;
import app.figma.server.api.v100000000.services.CacheSettingsService;
import app.figma.server.api.v100000000.services.LinkService;
import app.figma.server.api.v100000000.services.TokenService;
import app.figma.server.entities.CacheSettings;
import app.figma.server.entities.Link;
import app.figma.server.entities.Token;
import app.figma.server.events.AOReadyEvent;
import app.figma.server.helpers.CacheKey;
import app.figma.server.helpers.Option;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.figma.api.dto.ImagesFormat;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import net.java.ao.Query;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractFigmaHelper
implements FigmaHelper,
LifecycleAware,
InitializingBean,
DisposableBean {
    private Cache<CacheKey<CachedMethods>, Option<?>> cache;
    private final Cache<CacheKey<CachedMethods>, Option<?>> previewCache;
    private final CacheManager cacheManager;
    private final CacheSettingsService cacheSettingsService;
    private final EventPublisher eventPublisher;
    protected final TokenService tokenService;
    protected final LinkService linkService;
    protected final Figma figma;
    protected final HostHelper helper;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AbstractFigmaHelper(TokenService tokenService, LinkService linkService, Figma figma, HostHelper helper, CacheSettingsService cacheSettingsService, CacheManager cacheManager, EventPublisher eventPublisher) {
        this.tokenService = tokenService;
        this.linkService = linkService;
        this.figma = figma;
        this.helper = helper;
        this.cacheManager = cacheManager;
        this.cacheSettingsService = cacheSettingsService;
        this.eventPublisher = eventPublisher;
        this.previewCache = cacheManager.getCache(String.format("%s::preview", this.getClass().getCanonicalName()), this.getCacheLoader(), new CacheSettingsBuilder().remote().expireAfterWrite(15L, TimeUnit.MINUTES).build());
    }

    @Override
    public Response hasAccess(String key, String type) {
        try {
            boolean enforceACL = null != type && !type.equals("view");
            Token token = this.getTokenFromFileKey(key, enforceACL);
            return Response.ok((Object)(null != token ? 1 : 0)).build();
        }
        catch (Exception exception) {
            return Response.status((int)404).build();
        }
    }

    @Override
    public Response validate(String token, String key) {
        if (null != key) {
            boolean isValid = this.figma.validate(token, key, true);
            return Response.ok((Object)isValid).build();
        }
        FigmaUserDTO user = this.figma.user(token);
        boolean isValid = null != user;
        return Response.ok((Object)isValid).build();
    }

    @Override
    public Response invalidate(String id, String revision, String scale, String format) {
        if (null == this.cache) {
            return Response.noContent().build();
        }
        try {
            LinkDTO link = this.getLink(id);
            if (null != link) {
                CacheKey<CachedMethods> metadataCacheKey = CacheKey.builder().method(CachedMethods.METADATA_DTO).key("key", link.getKey()).key("nodeId", link.getNodeId()).key("revision", link.getRevision()).build();
                this.cache.remove(metadataCacheKey);
                CacheKey<CachedMethods> imageCacheKey = CacheKey.builder().method(CachedMethods.IMAGES).key("key", link.getKey()).key("nodeId", link.getNodeId()).key("revision", link.getRevision()).key("scale", scale).key("format", format).build();
                this.cache.remove(imageCacheKey);
                return Response.noContent().build();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Override
    public Response version(String id, String key, String forceRefresh) {
        try {
            FigmaVersionDTO version;
            boolean force = null != forceRefresh && forceRefresh.equals("true");
            Token token = this.getTokenFromFileKey(key, false);
            if (null != token && null != (version = this.figma.version(token.getToken(), id, key, force))) {
                return Response.ok((Object)version).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ignored) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Override
    public Response versions(String key, String after, String before, String limit, String forceRefresh) {
        try {
            List<FigmaVersionDTO> versions;
            boolean force = "true".equals(forceRefresh);
            Token token = this.getTokenFromFileKey(key, false);
            if (null != token && null != (versions = this.figma.versions(token.getToken(), key, after, before, limit, force))) {
                return Response.ok(PageDTO.from(versions)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ignored) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @Override
    public Response preview(String key, String nodeId, String revision, String scale, String format) {
        try {
            Token validToken = this.getTokenFromFileKey(key, true);
            if (null == validToken) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            int previewId = this.helper.getRandomGenerator().nextInt() & Integer.MAX_VALUE;
            CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.PREVIEW).key("id", String.format("tmp_%s", previewId)).parameter("key", key).parameter("nodeId", nodeId).parameter("revision", revision).build();
            LinkDTO link = (LinkDTO)this.fetch(cacheKey, false);
            if (null != link) {
                return this.view(String.valueOf(link.getId()), revision, scale, format, "false");
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception ignored) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @Override
    public Response view(String id, String revision, String scale, String format, String forceRefresh) {
        try {
            if (id.startsWith("legacyMacro") || id.startsWith("autoConvertMacro")) {
                String[] paths = id.split("_");
                String refId = paths[1];
                String entityId = paths[2];
                if (null != refId && null != entityId) {
                    return this.legacyMacroView(refId, entityId, scale, format, forceRefresh);
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            LinkDTO link = this.getLink(id);
            if (null != link) {
                String content;
                if (null != revision) {
                    link.setRevision(revision);
                }
                FigmaMetadataDTO metadata = this.metadata(link, forceRefresh);
                String string = content = !link.isPrototype() ? this.image(link, scale, format, forceRefresh) : null;
                if (null != metadata) {
                    ViewDTO result = new ViewDTO();
                    result.setId(link.getId());
                    result.setKey(link.getKey());
                    result.setNodeId(link.getNodeId());
                    result.setRevision(link.getRevision());
                    result.setPrototype(link.isPrototype());
                    result.setName(metadata.getName());
                    result.setFileName(metadata.getFileName());
                    result.setBackgroundColor(metadata.getBackgroundColor());
                    result.setWidth(metadata.getWidth());
                    result.setHeight(metadata.getHeight());
                    result.setLastModified(this.iso8601ToEpochMS(metadata.getLastModified()));
                    result.setProperties(link.getProperties());
                    result.setStatus(ViewDTO.Status.complete);
                    result.setContent(content);
                    result.setVersion(metadata.getVersion());
                    result.setLatestVersion(metadata.getLatestVersion());
                    result.setParent(metadata.getParent());
                    return Response.ok((Object)result).build();
                }
            }
        }
        catch (Exception ignored) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public abstract Response legacyMacroView(String var1, String var2, String var3, String var4, String var5);

    @Override
    public Response download(String id, String revision, String scale, String format) {
        try {
            LinkDTO link = this.getLink(id);
            if (null != link) {
                String version = null != revision && !revision.isEmpty() ? revision : link.getRevision();
                String result = this.getImageUrl(link.getKey(), link.getNodeId(), version, scale, format, true, true);
                if (null != result && !result.isEmpty()) {
                    URL url = new URL(result);
                    return Response.ok((Object)url.openStream()).build();
                }
            }
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private LinkDTO getLink(String id) {
        try {
            if (id.startsWith("tmp")) {
                CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.PREVIEW).key("id", id).build();
                LinkDTO link = (LinkDTO)this.fetch(cacheKey, false);
                if (null != link) {
                    if (new Date().getTime() < link.getExpires()) {
                        return link;
                    }
                    if (null != this.cache) {
                        this.cache.remove(cacheKey);
                    }
                }
                return null;
            }
            return this.linkService.toDTO((Link)this.linkService.findById(Integer.parseInt(id)));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected FigmaMetadataDTO metadata(LinkDTO link, String forceRefresh) {
        try {
            if (null != link) {
                boolean force = forceRefresh != null && forceRefresh.equalsIgnoreCase("true");
                CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.METADATA_DTO).key("key", link.getKey()).key("nodeId", link.getNodeId()).key("revision", link.getRevision()).parameter("forceRefresh", forceRefresh).build();
                return (FigmaMetadataDTO)this.fetch(cacheKey, force);
            }
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected String image(LinkDTO link, String scale, String format, String forceRefresh) {
        try {
            if (null != link) {
                boolean force = forceRefresh != null && forceRefresh.equalsIgnoreCase("true");
                CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.IMAGES).key("key", link.getKey()).key("nodeId", link.getNodeId()).key("revision", link.getRevision()).key("scale", scale).key("format", format).build();
                boolean alreadyExistsInCache = null != this.cache && this.cache.containsKey(cacheKey);
                boolean mustRetrieveFromFigma = !alreadyExistsInCache || force;
                cacheKey.getParameters().put("mustRetrieveFromFigma", Boolean.toString(mustRetrieveFromFigma));
                return (String)this.fetch(cacheKey, mustRetrieveFromFigma);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        return null;
    }

    private String getImageUrl(String key, String nodeId, String revision, String scale, String format, boolean forceRefresh, boolean enforceACL) {
        try {
            Token token = this.getTokenFromFileKey(key, enforceACL);
            return null != token ? this.figma.imageUrls(token.getToken(), key, nodeId, revision, scale, ImagesFormat.valueOf(format), forceRefresh) : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Token getTokenFromFileKey(String key, boolean enforceACL) {
        UserDTO user = this.helper.getUser();
        Page tokens = enforceACL ? this.tokenService.findAll(Query.select().where("ACCOUNT_ID = ?", new Object[]{user.getAccountId()})) : this.tokenService.findAll();
        return tokens.getValues().stream().filter(token -> this.figma.validate(token.getToken(), key, enforceACL)).findFirst().orElse(null);
    }

    protected long iso8601ToEpochMS(String value) {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(value);
        Instant instant = offsetDateTime.toInstant();
        Date date = Date.from(instant);
        return date.getTime();
    }

    private <T> T fetch(CacheKey<CachedMethods> cacheKey, boolean forceRefresh) {
        Cache<CacheKey<CachedMethods>, Option<?>> cache;
        Cache<CacheKey<CachedMethods>, Option<?>> cache2 = cache = CachedMethods.PREVIEW.equals((Object)cacheKey.getMethod()) ? this.previewCache : this.cache;
        if (null != cache) {
            Option result;
            if (forceRefresh) {
                cache.remove(cacheKey);
            }
            return null != (result = (Option)cache.get(cacheKey)) ? (T)result.getValue() : null;
        }
        Option result = (Option)this.getCacheLoader().load(cacheKey);
        return result.getValue();
    }

    private CacheLoader<CacheKey<CachedMethods>, Option<?>> getCacheLoader() {
        return new CacheLoader<CacheKey<CachedMethods>, Option<?>>(){

            @Nonnull
            public Option<?> load(@Nonnull CacheKey<CachedMethods> cacheKey) {
                try {
                    CachedMethods method = cacheKey.getMethod();
                    Map<String, String> params = cacheKey.getParameters();
                    switch (method) {
                        case PREVIEW: {
                            try {
                                String id = params.getOrDefault("id", null);
                                String key = params.getOrDefault("key", null);
                                String nodeId = params.getOrDefault("nodeId", "0:1");
                                String revision = params.getOrDefault("revision", null);
                                if (id == null || key == null) {
                                    throw new IllegalArgumentException();
                                }
                                LinkDTO result = new LinkDTO(key, nodeId);
                                result.setId(id);
                                result.setRevision(revision);
                                result.setExpires(new Date().getTime() + 900000L);
                                return new Option<LinkDTO>(result);
                            }
                            catch (Exception ignored) {
                                return new Option<Object>(null);
                            }
                        }
                        case METADATA_DTO: {
                            try {
                                String key = params.getOrDefault("key", null);
                                String nodeId = params.getOrDefault("nodeId", "0:1");
                                String revision = params.getOrDefault("revision", null);
                                String forceRefresh = params.getOrDefault("forceRefresh", "false");
                                boolean force = forceRefresh != null && forceRefresh.equalsIgnoreCase("true");
                                Token token = AbstractFigmaHelper.this.getTokenFromFileKey(key, false);
                                FigmaMetadataDTO result = null != token ? AbstractFigmaHelper.this.figma.metadata(token.getToken(), key, nodeId, revision, force) : null;
                                return new Option<Object>(result);
                            }
                            catch (Exception ignored) {
                                return new Option<Object>(null);
                            }
                        }
                        case IMAGES: {
                            try {
                                String key = params.getOrDefault("key", null);
                                String nodeId = params.getOrDefault("nodeId", "0:1");
                                String revision = params.getOrDefault("revision", null);
                                String scale = params.getOrDefault("scale", "1");
                                String format = params.getOrDefault("format", ImagesFormat.svg.name());
                                String mustRetrieveFromFigma = params.getOrDefault("mustRetrieveFromFigma", null);
                                boolean force = mustRetrieveFromFigma != null && mustRetrieveFromFigma.equalsIgnoreCase("true");
                                String imageUrl = AbstractFigmaHelper.this.getImageUrl(key, nodeId, revision, scale, format, force, false);
                                if (null == imageUrl) {
                                    return new Option<Object>(null);
                                }
                                URL url = new URL(imageUrl);
                                URLConnection conn = url.openConnection();
                                InputStream is = conn.getInputStream();
                                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                                String base64 = Base64.encodeBase64String((byte[])bytes);
                                String contentType = conn.getHeaderField("content-type");
                                String result = String.format("data:%s;base64,%s", null != contentType ? contentType : format, base64);
                                return new Option<String>(result);
                            }
                            catch (IOException e) {
                                return new Option<Object>(null);
                            }
                        }
                    }
                    throw new IllegalArgumentException();
                }
                catch (IllegalArgumentException ignored) {
                    return new Option<Object>(null);
                }
            }
        };
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onAOReadyEvent(AOReadyEvent event) {
        block4: {
            try {
                CacheSettings settings = (CacheSettings)this.cacheSettingsService.findOne(Query.select().limit(1).offset(0));
                if (null == settings || !settings.isEnabled()) break block4;
                int timeout = settings.getTimeout() > 0 ? settings.getTimeout() : 30;
                int maxEntries = settings.getMaxEntries() > 0 ? settings.getMaxEntries() : 50;
                Constants.CacheExpirationPolicy policy = Constants.CacheExpirationPolicy.EXPIRE_AFTER_WRITE;
                try {
                    policy = Constants.CacheExpirationPolicy.valueOf(settings.getExpirationPolicy());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                CacheSettingsBuilder cacheSettingsBuilder = new CacheSettingsBuilder().remote().maxEntries(maxEntries);
                cacheSettingsBuilder = policy.equals((Object)Constants.CacheExpirationPolicy.EXPIRE_AFTER_WRITE) ? cacheSettingsBuilder.expireAfterWrite((long)timeout, TimeUnit.MINUTES) : cacheSettingsBuilder.expireAfterAccess((long)timeout, TimeUnit.MINUTES);
                this.cache = this.cacheManager.getCache(this.getClass().getCanonicalName(), this.getCacheLoader(), cacheSettingsBuilder.build());
            }
            catch (Exception ignored) {
                this.cache = null;
            }
        }
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    static enum CachedMethods {
        PREVIEW,
        METADATA_DTO,
        IMAGES;

    }
}

