/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server;

import app.figma.server.events.AOReadyEvent;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AOManager
implements InitializingBean,
DisposableBean {
    private final ActiveObjects activeObjects;
    private final EventPublisher eventPublisher;
    private boolean hasStarted = false;

    @Autowired
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AOManager(@ComponentImport EventPublisher eventPublisher, @ComponentImport ActiveObjects activeObjects) {
        this.eventPublisher = eventPublisher;
        this.activeObjects = activeObjects;
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (!this.hasStarted) {
            this.onStart();
        }
    }

    @EventListener
    public void onApplicationStarted(ApplicationStartedEvent event) {
        if (!this.hasStarted) {
            this.onStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStart() {
        this.hasStarted = true;
        ExecutorService executorService = Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)"app.figma::AOManager", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
        try {
            Future<Boolean> task = executorService.submit(this::initialize);
            boolean isInitialized = task.get(10L, TimeUnit.MINUTES);
            if (isInitialized) {
                this.eventPublisher.publish((Object)new AOReadyEvent());
            }
        }
        catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException exception) {
        }
        finally {
            executorService.shutdown();
        }
    }

    private Boolean initialize() {
        int count = 0;
        boolean isInitialized = false;
        while (!isInitialized && count < 10) {
            try {
                this.activeObjects.moduleMetaData().awaitInitialization(1L, TimeUnit.MINUTES);
                isInitialized = this.activeObjects.moduleMetaData().isInitialized();
            }
            catch (InterruptedException | ExecutionException | TimeoutException exp) {
                ++count;
            }
        }
        return isInitialized;
    }
}

