/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.velocity.htmlsafe.HtmlFragment;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ACServlet
extends HttpServlet {
    private final WebSudoManager webSudoManager;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final Plugin plugin;
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;
    private final PageBuilderService pageBuilderService;

    ACServlet(@ComponentImport WebSudoManager webSudoManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport UserManager userManager, @ComponentImport PluginRetrievalService pluginRetrievalService, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport WebResourceAssemblerFactory webResourceAssemblerFactory, @ComponentImport PageBuilderService pageBuilderService) {
        this.webSudoManager = webSudoManager;
        this.loginUriProvider = loginUriProvider;
        this.plugin = pluginRetrievalService.getPlugin();
        this.userManager = userManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.applicationProperties = applicationProperties;
        this.pageBuilderService = pageBuilderService;
        this.webResourceAssemblerFactory = webResourceAssemblerFactory;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isAllowed(req, resp)) {
            String response = "";
            resp.setContentType("text/html; charset=utf-8");
            try (PrintWriter writer = resp.getWriter();){
                String path = req.getPathInfo();
                String appKey = this.getAppKeyFromPath(path);
                if (!path.startsWith("/all.js") && !this.plugin.getKey().equals(appKey)) {
                    resp.sendError(400, "Bad request");
                }
                if (path.startsWith("/all.js")) {
                    resp.setContentType("application/javascript; charset=utf-8");
                    response = this.toScript();
                } else {
                    response = path.startsWith("/macro") ? this.toMacro() : (path.startsWith("/embed") ? this.toFrame() : this.toHost(req));
                }
                writer.write(response);
            }
            catch (Exception exp) {
                resp.sendError(500, exp.toString());
            }
        }
    }

    private String toScript() throws IOException {
        String platformId = this.applicationProperties.getPlatformId();
        String resourceName = String.format("/static/ap-%s.js", platformId.toLowerCase());
        return Resources.toString((URL)Resources.getResource((String)resourceName), (Charset)StandardCharsets.UTF_8);
    }

    private String toHost(HttpServletRequest req) throws IOException {
        StringBuilder sb = new StringBuilder();
        HtmlFragment resources = this.getResourcesForContext(String.format("%s-%s-atlassian-connect", this.plugin.getKey(), this.plugin.getPluginInformation().getVersion()));
        String appKey = this.getAppKeyFromPath(req.getPathInfo());
        String moduleKey = this.getModuleKeyFromPath(req.getPathInfo());
        Map<String, String> params = this.getModuleParams(moduleKey);
        Optional<String> userKey = Optional.of(Objects.requireNonNull(this.userManager.getRemoteUserKey()).getStringValue());
        params.put("ajs-remote-user-key", userKey.orElse(""));
        params.put("atl-product-name", this.getPlatformName());
        params.put(String.format("%s-lic", appKey), this.getLicenseState());
        Object urlSuffix = params.getOrDefault("url", "/");
        urlSuffix = (String)urlSuffix + String.format("%s%s", ((String)urlSuffix).contains("?") ? "&" : "?", String.join((CharSequence)"&", this.getDefaultQueryStringParameters(req)));
        sb.append("<html>");
        sb.append("<head>");
        sb.append(resources);
        params.forEach((k, v) -> sb.append(String.format("<meta name=\"%s\" content=\"%s\">", k, v)));
        sb.append("</head>");
        sb.append("<body>");
        sb.append(String.format("<iframe src=\"%1$s/plugins/servlet/atlassian-connect/embed/%2$s/%3$s%4$s\" style=\"border:none; overflow: hidden; width: 100%%;\" data-ap-appkey=\"%2$s\" data-ap-key=\"%3$s\"></iframe>", req.getContextPath(), this.plugin.getKey(), moduleKey, urlSuffix));
        sb.append("</body>");
        return sb.toString();
    }

    private String toFrame() throws IOException {
        StringBuilder sb = new StringBuilder();
        HtmlFragment resources = this.getResourcesForContext(String.format("%s-%s", this.plugin.getKey(), this.plugin.getPluginInformation().getVersion()));
        sb.append("<!doctype html>");
        sb.append("<html lang=\"en\" data-color-mode=\"light\" data-theme=\"dark:dark light:light spacing:spacing\">");
        sb.append("<head>");
        sb.append("<meta charset=\"UTF-8\">");
        sb.append("<meta name=\"decorator\" value=\"none\">");
        sb.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0\">");
        sb.append("<meta http-equiv=\"X-UA-Compatible\" content=\"ie=edge\">");
        sb.append("<meta name=\"referrer\" content=\"no-referrer\" />");
        sb.append("<link rel=\"stylesheet\" href=\"https://connect-cdn.atl-paas.net/themes/atlaskit-tokens_light.css\"></link>");
        sb.append(new HtmlFragment((Object)resources.toString()));
        sb.append("</head>");
        sb.append("<body>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private String toMacro() throws IOException {
        StringBuilder sb = new StringBuilder();
        HtmlFragment resources = this.getResourcesForContext(String.format("%s-%s-macro", this.plugin.getKey(), this.plugin.getPluginInformation().getVersion()));
        sb.append("<!doctype html>");
        sb.append("<html lang=\"en\" data-color-mode=\"light\" data-theme=\"dark:dark light:light spacing:spacing\">");
        sb.append("<head>");
        sb.append("<meta charset=\"UTF-8\">");
        sb.append("<meta name=\"decorator\" value=\"none\">");
        sb.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0\">");
        sb.append("<meta http-equiv=\"X-UA-Compatible\" content=\"ie=edge\">");
        sb.append("<meta name=\"referrer\" content=\"no-referrer\" />");
        sb.append("<link rel=\"stylesheet\" href=\"https://connect-cdn.atl-paas.net/themes/atlaskit-tokens_light.css\"></link>");
        sb.append(new HtmlFragment((Object)resources.toString()));
        sb.append("</head>");
        sb.append("<body>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private String getAppKeyFromPath(String path) {
        String[] pathElements = (String[])Arrays.stream(path.split("/")).filter(item -> !item.isEmpty()).toArray(String[]::new);
        if (path.startsWith("/all.js")) {
            return null;
        }
        if (path.startsWith("/embed") || path.startsWith("/macro")) {
            return pathElements[1];
        }
        return pathElements[0];
    }

    private String getModuleKeyFromPath(String path) {
        String[] pathElements = (String[])Arrays.stream(path.split("/")).filter(item -> !item.isEmpty()).toArray(String[]::new);
        if (path.startsWith("/all.js")) {
            return null;
        }
        if (path.startsWith("/embed")) {
            return pathElements[2];
        }
        return pathElements[1];
    }

    private String[] getDefaultQueryStringParameters(HttpServletRequest req) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String port = req.getServerPort() == 80 || req.getServerPort() == 443 ? "" : String.format(":%s", req.getServerPort());
        parameters.put("xdm_e", String.format("%s://%s%s", req.getScheme(), req.getServerName(), port));
        parameters.put("cp", this.getServletContext().getContextPath());
        parameters.put("lic", this.getLicenseState());
        parameters.put("xdm_c", "DO_NOT_USE");
        parameters.put("cv", "DO_NOT_USE");
        return (String[])parameters.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).toArray(String[]::new);
    }

    private HtmlFragment getResourcesForContext(String context) throws IOException {
        StringWriter writer = new StringWriter();
        if (context.endsWith("atlassian-connect")) {
            this.pageBuilderService.assembler().resources().requireContext(ResourcePhase.DEFER, context);
        } else {
            WebResourceAssembler assembler = this.webResourceAssemblerFactory.create().build();
            assembler.resources().requireContext(ResourcePhase.DEFER, context);
            WebResourceSet resources = assembler.assembled().drainIncludedResources();
            resources.writeHtmlTags((Writer)writer, UrlMode.AUTO);
        }
        ((Writer)writer).flush();
        return new HtmlFragment((Object)((Object)writer).toString());
    }

    private Map<String, String> getModuleParams(String moduleKey) {
        ModuleDescriptor descriptor = this.plugin.getModuleDescriptor(moduleKey);
        if (descriptor != null) {
            return descriptor.getParams();
        }
        return new HashMap<String, String>();
    }

    private String getLicenseState() {
        if (!this.isLicenseEnabled()) {
            return "active";
        }
        Option license = this.pluginLicenseManager.getLicense();
        return license.isDefined() && ((PluginLicense)license.get()).isValid() ? "active" : "none";
    }

    private boolean isLicenseEnabled() {
        Map params = this.plugin.getPluginInformation().getParameters();
        return !params.containsKey("atlassian-licensing-enabled") || Boolean.parseBoolean((String)params.get("atlassian-licensing-enabled"));
    }

    private String getPlatformName() {
        String platformId = this.applicationProperties.getPlatformId();
        switch (platformId.toLowerCase()) {
            case "jira": {
                return "Jira";
            }
            case "conf": {
                return "Confluence";
            }
        }
        return "";
    }

    private boolean isAllowed(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        String moduleKey = this.getModuleKeyFromPath(path);
        UserProfile user = this.userManager.getRemoteUser(req);
        if (user == null) {
            this.sendRedirectToLogin(req, resp);
            return false;
        }
        Map<String, String> params = this.getModuleParams(moduleKey);
        String decorator = params.getOrDefault("decorator", "");
        if (decorator.equals("atl.admin")) {
            try {
                this.webSudoManager.willExecuteWebSudoRequest(req);
            }
            catch (WebSudoSessionException ignored) {
                this.webSudoManager.enforceWebSudoProtection(req, resp);
                return false;
            }
            if (!this.isUserSysAdmin(user)) {
                resp.sendError(403);
                return false;
            }
        }
        return true;
    }

    private boolean isUserSysAdmin(UserProfile user) {
        return user != null && this.userManager.isSystemAdmin(user.getUserKey());
    }

    private void sendRedirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestUri = req.getRequestURI();
        String contextPath = req.getContextPath();
        if (!Strings.isNullOrEmpty((String)contextPath)) {
            requestUri = requestUri.substring(contextPath.length());
        }
        resp.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(requestUri)).toString());
    }
}

