
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition

import java.util.*;
import java.io.IOException;
import java.util.logging.Level;

import java.net.URI;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager
import com.atlassian.bamboo.task.TaskDefinition
import com.atlassian.bamboo.task.TaskDefinitionImpl
import com.atlassian.bamboo.task.TaskManager
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildLoggerManager
import com.atlassian.bamboo.build.Job
import com.atlassian.bamboo.build.logger.BuildLogger
import com.atlassian.bamboo.deployments.environments.Environment
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import org.valens.utils.DslHelper;

BuildLogger getLogger()
{
    return logger;
}

BuildContext getBuildContext() {
    return buildContext;
}

PlanManager getPlanManager() {
    return planManager;
}

TaskManager getTaskManager() {
    return taskManager;
}
    
EnvironmentService getEnvironmentService() {
    return environmentService;
}

List getRuntimeTasks() {
    return getBuildContext().getRuntimeTaskDefinitions();
}

void clear()
{
    getRuntimeTasks().clear();
}
    
void append(String key)
{
            
    List<TaskDefinition> lst = dslHelper.getTaskDefinitions(key);
    
    if(lst!=null)
    {
        
        List tasks = getRuntimeTasks();
            
        getLogger().addBuildLogEntry("Template tasks: " + lst.toString());
        
        for (TaskDefinition t : lst)
        {      
            long taskId = TaskConfigurationUtils.getUniqueId(tasks);
            
            TaskDefinition auxtask = new TaskDefinitionImpl(taskId,
                t.getPluginKey(),
                t.getUserDescription(),
                true,
                t.getConfiguration());
                        
            getRuntimeTasks().add(dslHelper.FromTaskDefinition(t,getBuildContext()));
        }
    
        getLogger().addBuildLogEntry("Final tasks: " + getRuntimeTasks().toString());
    }
    else
        getLogger().addBuildLogEntry("Build plan was not found !" );
}

void generictask(String name, String key, LinkedHashMap config, boolean finalizing,boolean enabled )
{
    List tasks = getRuntimeTasks();
    
    long taskId = TaskConfigurationUtils.getUniqueId(tasks);
    
    TaskDefinition auxtask = new TaskDefinitionImpl(taskId,
        key,
        name,
        true,
        config);
    
    auxtask.setFinalising(finalizing);

    auxtask.setEnabled(enabled);
    RuntimeTaskDefinition r = dslHelper.FromTaskDefinition(auxtask,getBuildContext())
    getRuntimeTasks().add(r);
}


void task(String key, LinkedHashMap config, boolean enabled )
{
    task("Generated task", key, config, enabled);
}

void task(String name, String key, LinkedHashMap config, boolean enabled )
{
    generictask(name, key, config, false, enabled);
}

void finaltask(String key, LinkedHashMap config, boolean enabled )
{
    finaltask("Generated final task", key, config, enabled);
}

void finaltask(String name, String key, LinkedHashMap config, boolean enabled )
{
    generictask(name, key, config, true, enabled);
}

void define (String name, String value)
{
    getBuildContext().getVariableContext()
    .addResultVariable(name, value);
}
