/*
 * Decompiled with CFR 0.152.
 */
package org.valens.variableprocessor;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.SimpleLogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Maps;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class GroovyProcessorBase {
    BuildContext buildContext = null;
    CustomVariableContext customVariableContext = null;
    private static final String CUSTOM_BAMBOO_TASK_ACTION = "custom.bamboo.task.action";
    private static final String CUSTOM_BAMBOO_TASKS_REG_LIST = "custom.bamboo.tasks.reg.list";
    private static final String CUSTOM_BAMBOO_CONDITION_LIST = "custom.bamboo.condition.list";
    private static final String CUSTOMBAMBOOTASKLIST = "custom.bamboo.task.list";
    private static final String SCRIPT = "script:";
    private static final Logger log = Logger.getLogger(GroovyProcessorBase.class);

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public GroovyProcessorBase(BuildContext buildContext, CustomVariableContext customVariableContext) {
        this.buildContext = buildContext;
        this.customVariableContext = customVariableContext;
    }

    public BuildContext call() throws Exception {
        this.processContext(this.buildContext.getVariableContext().getEffectiveVariables());
        return this.buildContext;
    }

    private void processContext(Map<String, VariableDefinitionContext> context) {
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)this.buildContext.getPlanResultKey());
        try {
            String condition;
            String value;
            HashMap nestedVariables = Maps.newHashMap();
            for (Map.Entry<String, VariableDefinitionContext> entry : context.entrySet()) {
                value = entry.getValue().getValue();
                String key = entry.getValue().getKey();
                if (value != null && value.startsWith(SCRIPT)) {
                    value = this.calculateGroovy(key, nestedVariables, value.substring(SCRIPT.length()));
                }
                VariableDefinitionContextImpl variable = new VariableDefinitionContextImpl(key, value, entry.getValue().getVariableType());
                nestedVariables.put(key, variable);
            }
            for (String key : nestedVariables.keySet()) {
                Object value1;
                VariableDefinitionContext item = (VariableDefinitionContext)nestedVariables.get(key);
                if (item == null || (value1 = item.getValue()) == null) continue;
                this.buildContext.getVariableContext().addLocalVariable(key, (String)value1);
            }
            Map map = this.buildContext.getBuildDefinition().getCustomConfiguration();
            if (map.get(CUSTOM_BAMBOO_CONDITION_LIST) == null || map.get(CUSTOM_BAMBOO_CONDITION_LIST).toString().trim().length() == 0) {
                log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)new SimpleLogEntry("conditions not set, skipping")));
            } else {
                condition = map.get(CUSTOM_BAMBOO_CONDITION_LIST).toString();
                String expression = map.get(CUSTOM_BAMBOO_TASKS_REG_LIST).toString();
                if (expression == null || expression.trim().length() == 0) {
                    expression = ".*";
                }
                value = this.calculateGroovy("Condition", nestedVariables, condition);
                for (TaskDefinition td : this.buildContext.getRuntimeTaskDefinitions()) {
                    if (td.getUserDescription() == null || !td.getUserDescription().matches(expression)) continue;
                    if (value.equalsIgnoreCase("true")) {
                        td.setEnabled(false);
                        log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)new SimpleLogEntry("Disabling task [" + td.getUserDescription() + "]")));
                        continue;
                    }
                    log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)new SimpleLogEntry("Skipping task [" + td.getUserDescription() + "]")));
                }
            }
            if (map.get(CUSTOMBAMBOOTASKLIST) == null || map.get(CUSTOMBAMBOOTASKLIST).toString().trim().length() == 0) {
                log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)new SimpleLogEntry("tasks list not set, skipping")));
            } else {
                condition = map.get(CUSTOMBAMBOOTASKLIST).toString();
                value = this.calculateGroovy("Condition", nestedVariables, condition);
                for (TaskDefinition td : this.buildContext.getRuntimeTaskDefinitions()) {
                    if (td.getUserDescription() != null && td.getUserDescription().matches(value)) {
                        boolean state = true;
                        if (map.get(CUSTOM_BAMBOO_TASK_ACTION) == null || map.get(CUSTOM_BAMBOO_TASK_ACTION).toString().equalsIgnoreCase("false")) {
                            state = false;
                        }
                        td.setEnabled(state);
                        log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)new SimpleLogEntry("Setting state [" + state + "] for task [" + td.getUserDescription() + "]")));
                        continue;
                    }
                    log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)new SimpleLogEntry("Task [" + td.getUserDescription() + "] is not matching [" + value + "]")));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Bamboo Groovy Variables: an unexpected exception occurred." + e.getMessage()));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)new ErrorLogEntry(sw.toString())));
            e.printStackTrace();
        }
    }

    private String calculateGroovy(String name, Map nestedVariables, String groovy) {
        String varname;
        String key;
        String value;
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)this.buildContext.getPlanResultKey());
        SimpleLogEntry logEntry = new SimpleLogEntry("Groovy found in " + name);
        Binding binding = new Binding();
        binding.setVariable("groovyVariableName", name);
        for (Map.Entry item : this.buildContext.getVariableContext().getOriginalVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        for (Map.Entry item : this.buildContext.getVariableContext().getEffectiveVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        for (Map.Entry item : this.buildContext.getVariableContext().getResultVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        for (PlanRepositoryDefinition rdef : this.buildContext.getVcsRepositories()) {
            for (String key2 : rdef.getVcsLocation().getConfiguration().keySet()) {
                varname = key2.trim().replaceAll("\\.", "_") + "_" + rdef.getPosition();
                value = (String)rdef.getVcsLocation().getConfiguration().get(key2);
                if (!varname.trim().matches("[a-zA-Z0-9_]*")) continue;
                binding.setVariable(varname, value);
            }
        }
        Iterator it = this.buildContext.getVcsRepositories().iterator();
        while (it.hasNext()) {
            try {
                PlanRepositoryDefinition rdef;
                rdef = (PlanRepositoryDefinition)it.next();
                for (String key2 : rdef.getBranch().getConfiguration().keySet()) {
                    varname = key2.trim().replaceAll("\\.", "_") + "_" + rdef.getPosition();
                    value = (String)rdef.getBranch().getConfiguration().get(key2);
                    if (!varname.trim().matches("[a-zA-Z0-9_]*")) continue;
                    binding.setVariable(varname, value);
                }
            }
            catch (Exception rdef) {
            }
        }
        log.info((Object)buildLogger.addBuildLogEntry("GroovyShell bindings: "));
        for (String s : binding.getVariables().keySet()) {
            if (s.toLowerCase().contains("password") || s.toLowerCase().contains("key")) continue;
            log.info((Object)buildLogger.addBuildLogEntry("    " + s + "=" + binding.getVariable(s)));
        }
        log.info((Object)buildLogger.addBuildLogEntry("Groovy Shell starting"));
        Object result = null;
        try {
            GroovyShell shell = new GroovyShell(binding);
            result = shell.evaluate("try{ " + groovy + " }catch(Exception e){ e.printStackTrace(); }");
            if (result == null) {
                result = "null";
            }
            logEntry = new SimpleLogEntry("Groovy script " + groovy + " evaluated to [" + result.toString() + "]");
            log.info((Object)buildLogger.addBuildLogEntry((LogEntry)logEntry));
        }
        catch (Throwable e) {
            buildLogger.addErrorLogEntry(e.getMessage(), e);
            e.printStackTrace();
        }
        return result != null ? result.toString() : null;
    }

    private BuildLoggerManager getBuildLoggerManager() {
        return (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
    }
}

