/*
 * Decompiled with CFR 0.152.
 */
package org.valens.utils;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinitionImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DslHelper {
    private PluginAccessor pluginAccessor;
    private EnvironmentService environmentService;
    private PlanManager planManager;

    public EnvironmentService getEnvironmentService() {
        if (this.environmentService == null) {
            this.environmentService = (EnvironmentService)ContainerManager.getComponent((String)"environmentService");
        }
        return this.environmentService;
    }

    public void setEnvironmentService(EnvironmentService environmentService) {
        this.environmentService = environmentService;
    }

    public PlanManager getPlanManager() {
        if (this.planManager == null) {
            this.planManager = (PlanManager)ContainerManager.getComponent((String)"planManager");
        }
        return this.planManager;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public PluginAccessor getPluginAccessor() {
        if (this.pluginAccessor == null) {
            this.pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
        }
        return this.pluginAccessor;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public RuntimeTaskDefinition FromTaskDefinition(TaskDefinition task) {
        return this.FromTaskDefinition(task, null);
    }

    public RuntimeTaskDefinition FromTaskDefinition(TaskDefinition taskDefinition, CommonContext commonContext) {
        RuntimeTaskDefinitionImpl runtimeTaskDefinition = new RuntimeTaskDefinitionImpl(taskDefinition);
        TaskModuleDescriptor taskDescriptor = this.getTaskDescriptor(taskDefinition.getPluginKey());
        if (taskDescriptor != null) {
            try {
                TaskTestResultsSupport taskTestResultsSupport;
                RuntimeTaskDataProvider runtimeConfigurator = taskDescriptor.getRuntimeTaskDataProvider();
                if (runtimeConfigurator != null) {
                    runtimeTaskDefinition.setRuntimeContext(runtimeConfigurator.populateRuntimeTaskData((TaskDefinition)runtimeTaskDefinition, commonContext));
                    runtimeTaskDefinition.setRuntimeData(runtimeConfigurator.createRuntimeTaskData((RuntimeTaskDefinition)runtimeTaskDefinition, commonContext));
                }
                if ((taskTestResultsSupport = (TaskTestResultsSupport)Narrow.downTo((Object)taskDescriptor.getTaskConfigurator(), TaskTestResultsSupport.class)) != null) {
                    runtimeTaskDefinition.setProducesTestResults(taskTestResultsSupport.taskProducesTestResults(taskDefinition));
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return runtimeTaskDefinition;
    }

    public TaskModuleDescriptor getTaskDescriptor(@Nullable String pluginKey) {
        if (StringUtils.isNotEmpty(pluginKey)) {
            ModuleDescriptor descriptor = this.getPluginAccessor().getEnabledPluginModule(pluginKey);
            return (TaskModuleDescriptor)Narrow.reinterpret((Object)descriptor, TaskModuleDescriptor.class);
        }
        return null;
    }

    public List<TaskDefinition> getTaskDefinitions(String key) {
        try {
            Plan p = null;
            Environment sourceEnv = null;
            if (key.matches(".*-.*-.*")) {
                p = this.getPlanManager().getPlanByKey(key, Chain.class);
            }
            if (key.matches("[0-9]*")) {
                sourceEnv = this.getEnvironmentService().getEnvironment(Long.parseLong(key));
            }
            List lst = null;
            if (p != null) {
                lst = p.getBuildDefinition().getTaskDefinitions();
            }
            if (sourceEnv != null) {
                lst = sourceEnv.getTaskDefinitions();
            }
            return lst;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

