/*
 * Decompiled with CFR 0.152.
 */
package org.valens.prejobactions;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactoryImpl;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.spring.container.ContainerManager;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileUtil;
import org.apache.commons.vfs2.VFS;
import org.slf4j.LoggerFactory;
import org.valens.bamboo.conditions.ConditionEvaluatorImpl;
import org.valens.bamboo.conditions.ConditionType;
import org.valens.prejobactions.AbstractPreJobAction;
import org.valens.utils.Constants;
import org.valens.utils.DslHelper;
import org.valens.variableprocessor.GroovyProcessorBase;

public class DslPreJobAction
extends AbstractPreJobAction {
    private static boolean debug = LoggerFactory.getLogger(DslPreJobAction.class).isDebugEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readGroovyHeader() {
        InputStream in = this.getClass().getResourceAsStream("/groovy/header.groovy");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try {
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger(DslPreJobAction.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DslPreJobAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return "";
    }

    private void populateBinding(BuildContext buildContext, Binding binding) {
        String varname;
        String key;
        String value;
        for (Map.Entry item : buildContext.getVariableContext().getOriginalVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        for (Map.Entry item : buildContext.getVariableContext().getEffectiveVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        for (Map.Entry item : buildContext.getVariableContext().getResultVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        for (PlanRepositoryDefinition rdef : buildContext.getVcsRepositories()) {
            for (String key2 : rdef.getBranch().getConfiguration().keySet()) {
                varname = key2.trim().replaceAll("\\.", "_") + "_" + rdef.getPosition();
                value = (String)rdef.getBranch().getConfiguration().get(key2);
                if (!varname.trim().matches("[a-zA-Z0-9_]*")) continue;
                binding.setVariable(varname, value);
            }
        }
        Iterator it = buildContext.getVcsRepositories().iterator();
        while (it.hasNext()) {
            try {
                PlanRepositoryDefinition rdef;
                rdef = (PlanRepositoryDefinition)it.next();
                for (String key2 : rdef.getVcsBranchDetectionOptions().getConfiguration().keySet()) {
                    varname = key2.trim().replaceAll("\\.", "_") + "_" + rdef.getPosition();
                    value = (String)rdef.getVcsBranchDetectionOptions().getConfiguration().get(key2);
                    if (!varname.trim().matches("[a-zA-Z0-9_]*")) continue;
                    binding.setVariable(varname, value);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private void logMap(BuildLogger buildLogger, Map map) {
        buildLogger.addBuildLogEntry("[");
        for (Object s : map.keySet()) {
            if (s.toString().toLowerCase().matches("password")) {
                buildLogger.addBuildLogEntry("'" + s + "':'*********',");
                continue;
            }
            buildLogger.addBuildLogEntry("'" + s + "':'" + map.get(s) + "',");
        }
        buildLogger.addBuildLogEntry("]");
    }

    private void processDSL(StageExecution se, BuildContext bc) {
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)bc.getPlanResultKey());
        buildLogger.addBuildLogEntry("DSL Processing starting... ");
        try {
            buildLogger.addBuildLogEntry("   on " + InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String header = this.readGroovyHeader();
        for (TaskDefinition t : bc.getBuildDefinition().getTaskDefinitions()) {
            if (debug) {
                buildLogger.addBuildLogEntry(t.toString());
                this.logMap(buildLogger, t.getConfiguration());
            }
            VariableSubstitutorFactoryImpl vf = new VariableSubstitutorFactoryImpl();
            if (Constants.PLUGIN_KEY.equalsIgnoreCase(t.getPluginKey()) && t.isEnabled()) {
                String src = "";
                String filepath = (String)t.getConfiguration().get("custom.bamboo.dsl.filename");
                filepath = vf.newSubstitutorForGlobalContext().substituteString(filepath);
                filepath = this.getCustomVariableContext().substituteString(filepath);
                if (filepath.trim().length() > 0) {
                    try {
                        FileSystemManager fsManager = VFS.getManager();
                        FileObject dslFile = fsManager.resolveFile(filepath);
                        if (dslFile.exists() && dslFile.isReadable()) {
                            src = new String(FileUtil.getContent(dslFile));
                        }
                    }
                    catch (FileSystemException ex) {
                        buildLogger.addErrorLogEntry("An error occured", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        buildLogger.addErrorLogEntry("An error occured", (Throwable)ex);
                    }
                } else {
                    src = (String)t.getConfiguration().get("source");
                }
                src = vf.newSubstitutorForGlobalContext().substituteString(src);
                src = this.getCustomVariableContext().substituteString(src);
                DslHelper dslHelper = new DslHelper();
                dslHelper.setPluginAccessor(this.getPluginAccessor());
                dslHelper.setEnvironmentService(this.getEnvironmentService());
                dslHelper.setPlanManager(this.getPlanManager());
                Binding binding = new Binding();
                binding.setVariable("logger", buildLogger);
                binding.setVariable("dslHelper", dslHelper);
                binding.setVariable("current_task", t);
                binding.setVariable("planManager", this.getPlanManager());
                binding.setVariable("environmentService", this.getEnvironmentService());
                binding.setVariable("buildContext", bc);
                this.populateBinding(bc, binding);
                if (debug) {
                    buildLogger.addBuildLogEntry("GroovyShell bindings: ");
                    for (String s : binding.getVariables().keySet()) {
                        if (s.toLowerCase().contains("password") || s.toLowerCase().contains("key")) continue;
                        buildLogger.addBuildLogEntry("    " + s + "=" + binding.getVariable(s));
                    }
                }
                Object result = null;
                GroovyShell shell = new GroovyShell(this.getClass().getClassLoader(), binding);
                result = shell.evaluate(header + System.getProperty("line.separator") + "try { " + src + " } catch(Throwable e){     e.printStackTrace();     getLogger().addErrorLogEntry(\"\"+ e.getMessage(),e);     throw e;}");
                if (result == null) {
                    result = "";
                }
                buildLogger.addBuildLogEntry("Groovy script result task list [" + bc.getRuntimeTaskDefinitions() + "]");
                continue;
            }
            buildLogger.addBuildLogEntry("DSL Processing skipping: " + t.getUserDescription() + " - " + t.getPluginKey());
        }
    }

    private void processGroovyVars(StageExecution se, BuildContext bc) {
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)bc.getPlanResultKey());
        try {
            GroovyProcessorBase gpb = new GroovyProcessorBase(bc, this.getCustomVariableContext());
            gpb.call();
        }
        catch (Exception ex) {
            buildLogger.addErrorLogEntry("An error occured", (Throwable)ex);
        }
    }

    @Override
    public void execute(StageExecution se, BuildContext bc) {
        ConditionEvaluatorImpl eval = new ConditionEvaluatorImpl(this.getLicenseManager());
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)bc.getPlanResultKey());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            buildLogger.addErrorLogEntry("The DSL/Dynamic plans plugin license has expired or is invalid");
            return;
        }
        this.processDSL(se, bc);
        this.processGroovyVars(se, bc);
    }

    private BuildLoggerManager getBuildLoggerManager() {
        return (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
    }
}

