/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.servlets;

import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.valens.bamboo.conditions.ConditionEvaluatorImpl;
import org.valens.bamboo.conditions.ConditionType;
import org.valens.entity.GenericBambooEntity;

public class GeneratorServlet
extends HttpServlet {
    private PlanManager planManager;
    private CachedPlanManager cachedPlanManager;
    private BuildDefinitionConverter buildDefinitionConverter;
    private PluginAccessor pluginAccessor;
    private TransactionTemplate transactionTemplate;
    private TaskConfigurationService taskConfigurationService;
    private BuildDefinitionManager buildDefinitionManager;
    private ArtifactDefinitionManager artifactDefinitionManager;
    private ServerLifecycleManager serverLifecycleManager;
    private DeploymentProjectService deploymentProjectService;
    private VariableDefinitionManager variableDefinitionManager;
    private VariableConfigurationService variableConfigurationService;
    private NotificationManager notificationManager;
    private PluginLicenseManager licenseManager;
    private EnvironmentService environmentService;
    private EnvironmentTaskService environmentTaskService;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private TemplateRenderer templateRenderer;
    private EventPublisher eventPublisher;
    String sync = "";

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public PlanManager getPlanManager() {
        return this.planManager;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public BuildDefinitionManager getBuildDefinitionManager() {
        return this.buildDefinitionManager;
    }

    public void setBuildDefinitionManager(BuildDefinitionManager buildDefinitionManager) {
        this.buildDefinitionManager = buildDefinitionManager;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public CachedPlanManager getCachedPlanManager() {
        return this.cachedPlanManager;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public BuildDefinitionConverter getBuildDefinitionConverter() {
        return this.buildDefinitionConverter;
    }

    public void setBuildDefinitionConverter(BuildDefinitionConverter buildDefinitionConverter) {
        this.buildDefinitionConverter = buildDefinitionConverter;
    }

    public TaskConfigurationService getTaskConfigurationService() {
        return this.taskConfigurationService;
    }

    public void setTaskConfigurationService(TaskConfigurationService taskConfigurationService) {
        this.taskConfigurationService = taskConfigurationService;
    }

    public ArtifactDefinitionManager getArtifactDefinitionManager() {
        return this.artifactDefinitionManager;
    }

    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    public DeploymentProjectService getDeploymentProjectService() {
        return this.deploymentProjectService;
    }

    public void setDeploymentProjectService(DeploymentProjectService deploymentProjectService) {
        this.deploymentProjectService = deploymentProjectService;
    }

    public VariableDefinitionManager getVariableDefinitionManager() {
        return this.variableDefinitionManager;
    }

    public void setVariableDefinitionManager(VariableDefinitionManager variableDefinitionManager) {
        this.variableDefinitionManager = variableDefinitionManager;
    }

    public EnvironmentService getEnvironmentService() {
        return this.environmentService;
    }

    public void setEnvironmentService(EnvironmentService environmentService) {
        this.environmentService = environmentService;
    }

    public EnvironmentTaskService getEnvironmentTaskService() {
        return this.environmentTaskService;
    }

    public void setEnvironmentTaskService(EnvironmentTaskService environmentTaskService) {
        this.environmentTaskService = environmentTaskService;
    }

    public ServerLifecycleManager getServerLifecycleManager() {
        return this.serverLifecycleManager;
    }

    public void setServerLifecycleManager(ServerLifecycleManager serverLifecycleManager) {
        this.serverLifecycleManager = serverLifecycleManager;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public VariableConfigurationService getVariableConfigurationService() {
        return this.variableConfigurationService;
    }

    public void setVariableConfigurationService(VariableConfigurationService variableConfigurationService) {
        this.variableConfigurationService = variableConfigurationService;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public PluginLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String username = this.getUserManager().getRemoteUsername(request);
        if (username == null || !this.getUserManager().isSystemAdmin(username)) {
            this.redirectToLogin(request, response);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        ArrayList<GenericBambooEntity> plans = new ArrayList<GenericBambooEntity>();
        HashMap<String, Object> par = new HashMap<String, Object>();
        if (this.getPlanManager() != null) {
            for (TopLevelPlan p : this.getPlanManager().getAllPlansUnrestricted()) {
                for (Job j : p.getAllJobs()) {
                    plans.add(new GenericBambooEntity(j.getKey(), j.getName()));
                }
            }
        }
        par.put("plans", plans);
        ConditionEvaluatorImpl eval = new ConditionEvaluatorImpl(this.getLicenseManager());
        StringBuffer result = new StringBuffer();
        if (request.getParameter("plan") != null) {
            try {
                Job job = (Job)this.getPlanManager().getPlanByKey(PlanKeys.getPlanKey((String)request.getParameter("plan")));
                for (TaskDefinition t : job.getBuildDefinition().getTaskDefinitions()) {
                    if (t.isFinalising()) {
                        result.append("finaltask ");
                    } else {
                        result.append("task ");
                    }
                    result.append(String.format(" \"%s\",\"%s\",\n", t.getUserDescription().replaceAll("\"", "\\\\\""), t.getPluginKey()));
                    result.append("  [\n");
                    int k = 0;
                    for (Object s : t.getConfiguration().keySet()) {
                        if (s.toString().toLowerCase().matches("password")) {
                            result.append(String.format("    \"%s\":\"**********\"", s));
                        } else {
                            result.append(String.format("    \"%s\":\"\"\"%s\"\"\"", s, ((String)t.getConfiguration().get(s)).replaceAll("\"", "\\\\\"").replaceAll("\\$", "\\\\\\$")));
                        }
                        if (++k < t.getConfiguration().size()) {
                            result.append(",\n");
                            continue;
                        }
                        result.append("\n");
                    }
                    result.append("  ],\n");
                    if (t.isEnabled()) {
                        result.append("true\n\n ");
                        continue;
                    }
                    result.append("false\n\n ");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        par.put("result", result.toString());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            this.getTemplateRenderer().render("templates/invalidLicense.vm", par, (Writer)response.getWriter());
        } else {
            this.getTemplateRenderer().render("templates/generateplan.vm", par, (Writer)response.getWriter());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    public URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

