/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
public class HdfsPartialListing {
    private final List<HdfsFileStatus> partialListing;
    private final int parentIdx;
    private final RemoteException exception;

    public HdfsPartialListing(int parentIdx, List<HdfsFileStatus> partialListing) {
        this(parentIdx, partialListing, null);
    }

    public HdfsPartialListing(int parentIdx, RemoteException exception) {
        this(parentIdx, null, exception);
    }

    private HdfsPartialListing(int parentIdx, List<HdfsFileStatus> partialListing, RemoteException exception) {
        Preconditions.checkArgument((boolean)(partialListing == null ^ exception == null));
        this.parentIdx = parentIdx;
        this.partialListing = partialListing;
        this.exception = exception;
    }

    public int getParentIdx() {
        return this.parentIdx;
    }

    public List<HdfsFileStatus> getPartialListing() {
        return this.partialListing;
    }

    public RemoteException getException() {
        return this.exception;
    }

    public String toString() {
        return new ToStringBuilder(this).append("partialListing", this.partialListing).append("parentIdx", this.parentIdx).append("exception", this.exception).toString();
    }
}

