/*
 * Decompiled with CFR 0.152.
 */
package org.valens.tasks;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.plugin.PluginAccessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DslTaskConfigurator
extends AbstractTaskConfigurator {
    private PluginAccessor pluginAccessor;

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("custom.bamboo.dsl.filename", params.getString("custom.bamboo.dsl.filename"));
        config.put("source", params.getString("source"));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("source", "");
        context.put("custom.bamboo.dsl.filename", "");
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("source", taskDefinition.getConfiguration().get("source"));
        context.put("custom.bamboo.dsl.filename", taskDefinition.getConfiguration().get("custom.bamboo.dsl.filename"));
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put("custom.bamboo.dsl.filename", taskDefinition.getConfiguration().get("custom.bamboo.dsl.filename"));
        context.put("source", taskDefinition.getConfiguration().get("source"));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
    }
}

