/*
 * Decompiled with CFR 0.152.
 */
package org.valens.prebuildactions;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactoryImpl;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.spring.container.ContainerManager;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;
import org.valens.prebuildactions.AbstractPreBuildAction;
import org.valens.utils.DslHelper;
import org.valens.variableprocessor.GroovyProcessorBase;

public class DslPreBuildAction
extends AbstractPreBuildAction {
    private static boolean debug = LoggerFactory.getLogger(DslPreBuildAction.class).isDebugEnabled();

    @Override
    public BuildContext call() throws InterruptedException, Exception {
        this.execute(null, this.buildContext);
        return this.buildContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readGroovyHeader() {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/groovy/header.groovy");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try {
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger(DslPreBuildAction.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DslPreBuildAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return "";
    }

    private void populateBinding(BuildContext buildContext, Binding binding) {
        String varname;
        PlanRepositoryDefinition rdef2;
        String key;
        String value;
        for (Map.Entry item : buildContext.getVariableContext().getOriginalVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        for (Map.Entry item : buildContext.getVariableContext().getEffectiveVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        for (Map.Entry item : buildContext.getVariableContext().getResultVariables().entrySet()) {
            value = ((VariableDefinitionContext)item.getValue()).getValue();
            key = ((VariableDefinitionContext)item.getValue()).getKey();
            key = key.replaceAll("\\.", "_");
            binding.setVariable(key, value);
        }
        Iterator it = buildContext.getVcsRepositories().iterator();
        while (it.hasNext()) {
            try {
                rdef2 = (PlanRepositoryDefinition)it.next();
                for (String key2 : rdef2.getVcsLocation().getConfiguration().keySet()) {
                    varname = key2.trim().replaceAll("\\.", "_") + "_" + rdef2.getPosition();
                    value = (String)rdef2.getVcsLocation().getConfiguration().get(key2);
                    if (!varname.trim().matches("[a-zA-Z0-9_]*")) continue;
                    binding.setVariable(varname, value);
                }
            }
            catch (Exception rdef2) {
            }
        }
        it = buildContext.getVcsRepositories().iterator();
        while (it.hasNext()) {
            try {
                rdef2 = (PlanRepositoryDefinition)it.next();
                for (String key2 : rdef2.getBranch().getConfiguration().keySet()) {
                    varname = key2.trim().replaceAll("\\.", "_") + "_" + rdef2.getPosition();
                    value = (String)rdef2.getBranch().getConfiguration().get(key2);
                    if (!varname.trim().matches("[a-zA-Z0-9_]*")) continue;
                    binding.setVariable(varname, value);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private void logMap(BuildLogger buildLogger, Map map) {
        buildLogger.addBuildLogEntry("[");
        for (Object s : map.keySet()) {
            if (s.toString().toLowerCase().matches("password")) {
                buildLogger.addBuildLogEntry("'" + s + "':'*********',");
                continue;
            }
            buildLogger.addBuildLogEntry("'" + s + "':'" + map.get(s) + "',");
        }
        buildLogger.addBuildLogEntry("]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDSL(StageExecution sec, BuildContext bc) {
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)bc.getPlanResultKey());
        buildLogger.addBuildLogEntry("DSL Pre Build Processing starting... ");
        try {
            buildLogger.addBuildLogEntry("   on " + InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String header = this.readGroovyHeader();
        VariableSubstitutorFactoryImpl vf = new VariableSubstitutorFactoryImpl();
        String src = "";
        String filepath = "bamboo.dsl.buildconfig";
        Map customConfiguration = bc.getBuildDefinition().getCustomConfiguration();
        filepath = customConfiguration.get("custom.bamboo.dsl.filename") == null || customConfiguration.get("custom.bamboo.dsl.filename").toString().trim().length() == 0 ? "bamboo.dsl.buildconfig" : customConfiguration.get("custom.bamboo.dsl.filename").toString();
        if (customConfiguration.get("custom.bamboo.dsl.disabled") != null && customConfiguration.get("custom.bamboo.dsl.disabled").toString().equalsIgnoreCase("true")) {
            return;
        }
        boolean required = true;
        if (customConfiguration.get("custom.bamboo.dsl.filename.required") == null || customConfiguration.get("custom.bamboo.dsl.filename.required").toString().equalsIgnoreCase("false")) {
            required = false;
        }
        File buildWorkingDirectory = BuildContextHelper.getBuildWorkingDirectory((BuildContext)bc);
        File buildFile = new File(buildWorkingDirectory.getAbsolutePath() + File.separatorChar + filepath);
        if (required && !buildFile.exists()) {
            throw new RuntimeException("Build File was NOT found !");
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(buildFile);
            src = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException ex) {
            buildLogger.addBuildLogEntry("Job Default DSL was not found at " + buildWorkingDirectory.getAbsolutePath() + File.separatorChar + filepath);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
        }
        DslHelper dslHelper = new DslHelper();
        dslHelper.setEnvironmentService(this.getEnvironmentService());
        dslHelper.setPlanManager(this.getPlanManager());
        Binding binding = new Binding();
        binding.setVariable("logger", buildLogger);
        binding.setVariable("dslHelper", dslHelper);
        binding.setVariable("planManager", this.getPlanManager());
        binding.setVariable("environmentService", this.getEnvironmentService());
        binding.setVariable("buildContext", bc);
        this.populateBinding(bc, binding);
        if (debug) {
            buildLogger.addBuildLogEntry("GroovyShell bindings: ");
            for (String s : binding.getVariables().keySet()) {
                if (s.toLowerCase().contains("password") || s.toLowerCase().contains("key")) continue;
                buildLogger.addBuildLogEntry("    " + s + "=" + binding.getVariable(s));
            }
        }
        Object result = null;
        GroovyShell shell = new GroovyShell(binding);
        result = shell.evaluate(header + System.getProperty("line.separator") + "try { " + src + " } catch(Throwable e){     e.printStackTrace();     getLogger().addErrorLogEntry(\"\"+ e.getMessage(),e);     throw e;}");
        if (result == null) {
            result = "";
        }
        buildLogger.addBuildLogEntry("Groovy script result task list [" + bc.getRuntimeTaskDefinitions() + "]");
    }

    private void processGroovyVars(StageExecution se, BuildContext bc) {
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)bc.getPlanResultKey());
        try {
            GroovyProcessorBase gpb = new GroovyProcessorBase(bc, this.getCustomVariableContext());
            bc = gpb.call();
        }
        catch (Exception ex) {
            buildLogger.addErrorLogEntry("An error occured", (Throwable)ex);
        }
    }

    public void execute(StageExecution se, BuildContext bc) {
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)bc.getPlanResultKey());
        this.processDSL(se, bc);
        this.processGroovyVars(se, bc);
    }

    private BuildLoggerManager getBuildLoggerManager() {
        return (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
    }
}

