/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.conditions;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import org.valens.bamboo.conditions.ConditionEvaluator;
import org.valens.bamboo.conditions.ConditionType;

public class ConditionEvaluatorImpl
implements ConditionEvaluator {
    PluginLicenseManager licenseManager;

    public ConditionEvaluatorImpl(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    public boolean evaluate(ConditionType type) {
        switch (type) {
            case LICENSED: {
                return this.isLicenseValid();
            }
        }
        return false;
    }

    private boolean isLicenseValid() {
        boolean isLicensed = false;
        boolean hasErrors = false;
        for (PluginLicense pluginLicense : this.licenseManager.getLicense()) {
            isLicensed = true;
            hasErrors = hasErrors || pluginLicense.getError().isDefined();
        }
        isLicensed = isLicensed && !hasErrors;
        return isLicensed;
    }
}

