/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.servlets;

import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.valens.bamboo.base.CoreComponentsAbstractServlet;
import org.valens.bamboo.conditions.ConditionEvaluator;
import org.valens.bamboo.conditions.ConditionType;
import org.valens.bamboo.entities.TemplatedPlanEntity;
import org.valens.bamboo.servlets.LoggingServlet;

@Scanned
public class TemplatesReportServlet
extends CoreComponentsAbstractServlet {
    @Autowired
    public TemplatesReportServlet(@ComponentImport PlanManager planManager, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport TaskConfigurationService taskConfigurationService, @ComponentImport BuildDefinitionManager buildDefinitionManager, @ComponentImport ArtifactDefinitionManager artifactDefinitionManager, @ComponentImport ServerLifecycleManager serverLifecycleManager, @ComponentImport DeploymentProjectService deploymentProjectService, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport VariableConfigurationService variableConfigurationService, @ComponentImport NotificationManager notificationManager, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport EnvironmentService environmentService, @ComponentImport EnvironmentTaskService environmentTaskService, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport EventPublisher eventPublisher, @ComponentImport ChainBranchManager chainBranchManager, @ComponentImport BandanaManager bandanaManager) {
        super(planManager, cachedPlanManager, pluginAccessor, transactionTemplate, taskConfigurationService, buildDefinitionManager, artifactDefinitionManager, serverLifecycleManager, deploymentProjectService, variableDefinitionManager, variableConfigurationService, notificationManager, licenseManager, environmentService, environmentTaskService, userManager, loginUriProvider, templateRenderer, eventPublisher, chainBranchManager, bandanaManager);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        ArrayList<TemplatedPlanEntity> goodPlans = new ArrayList<TemplatedPlanEntity>();
        ArrayList<TemplatedPlanEntity> brokenPlans = new ArrayList<TemplatedPlanEntity>();
        ArrayList<TemplatedPlanEntity> notTemplated = new ArrayList<TemplatedPlanEntity>();
        HashMap<String, Object> par = new HashMap<String, Object>();
        par.put("trigger", (Object)this);
        par.put("eventText", "");
        for (ImmutableTopLevelPlan planChain : this.getCachedPlanManager().getPlans(ImmutableTopLevelPlan.class)) {
            for (ImmutableChainStage stage : planChain.getAllStages()) {
                for (ImmutableJob immutableJob : stage.getJobs()) {
                    Job job = (Job)this.getPlanManager().getPlanByKey(immutableJob.getPlanKey());
                    if (job == null) continue;
                    List sourceVariables = this.getVariableDefinitionManager().getPlanVariables((PlanIdentifier)job.getParent());
                    StringBuffer buf = new StringBuffer("<b>Variables:</b><br/>");
                    for (VariableDefinition v1 : sourceVariables) {
                        if (v1.getKey().toLowerCase().contains("password") || v1.getKey().toLowerCase().contains("secret")) continue;
                        buf.append("<div style='width: 100%'>" + v1.getKey() + "=" + v1.getValue() + "</div>");
                    }
                    buf.append("<b>Artifacts:</b><br/>");
                    for (ArtifactDefinition artifact : this.getArtifactDefinitionManager().findArtifactDefinitionsByPlan((ImmutablePlan)job)) {
                        buf.append("<div style='width: 100%'>" + artifact.getName() + "=" + artifact.getCopyPattern() + "</div>");
                    }
                    BuildDefinition buildDefinition = job.getBuildDefinition();
                    Map customConfiguration = buildDefinition.getCustomConfiguration();
                    if (customConfiguration.containsKey("custom.bamboo.template.list") && ((String)customConfiguration.get("custom.bamboo.template.list")).contains("=")) {
                        String selectedKey = ((String)customConfiguration.get("custom.bamboo.template.list")).split("=")[1];
                        LoggingServlet.warn("Found a plan ( " + job.getKey() + " ) that has a template " + selectedKey);
                        String[] tokens = selectedKey.split("-");
                        String templateKey = tokens[0] + "-" + tokens[1];
                        PlanKey planKey = PlanKeys.getPlanKey((String)templateKey);
                        Chain templateChain = (Chain)this.getPlanManager().getPlanByKey(planKey);
                        if (templateChain == null) {
                            brokenPlans.add(new TemplatedPlanEntity(job.getKey(), selectedKey, "Invalid - template missing", buf.toString()));
                            continue;
                        }
                        for (ChainStage chainTemplateStage : templateChain.getStages()) {
                            for (Job templateJob : chainTemplateStage.getJobs()) {
                                if (!selectedKey.trim().equalsIgnoreCase(templateJob.getKey().trim())) continue;
                                goodPlans.add(new TemplatedPlanEntity(job.getKey(), selectedKey, "Template present", buf.toString()));
                            }
                        }
                        continue;
                    }
                    notTemplated.add(new TemplatedPlanEntity(job.getKey(), "", "Not templated", buf.toString()));
                }
            }
        }
        par.put("goodPlans", goodPlans);
        par.put("notTemplated", notTemplated);
        par.put("brokenPlans", brokenPlans);
        ConditionEvaluator eval = new ConditionEvaluator(this.getLicenseManager());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            this.getTemplateRenderer().render("templates/invalidLicense.vm", par, (Writer)response.getWriter());
        } else {
            this.getTemplateRenderer().render("templates/reports/template.builds.vm", par, (Writer)response.getWriter());
        }
    }
}

