/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.servlets;

import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingServlet
extends HttpServlet {
    protected static final Logger jlog = LoggerFactory.getLogger(LoggingServlet.class);
    private static Queue<String> log = new LinkedList<String>();
    private static boolean debug = LoggerFactory.getLogger(LoggingServlet.class).isDebugEnabled();
    private static final int LOGLIMIT = 1000;

    public static Queue<String> getLog() {
        if (log == null) {
            log = new LinkedList<String>();
        }
        if (log.size() > 1000) {
            while (log.size() > 1000) {
                log.remove();
            }
        }
        return log;
    }

    public static void setLog(Queue<String> log) {
        LoggingServlet.log = log;
    }

    public static void debug(String s) {
        if (debug) {
            LoggingServlet.getLog().add(new Date(System.currentTimeMillis()).toString() + " " + s);
            LoggingServlet.getLog().add("<br/>");
        }
        jlog.debug(s);
    }

    public static void warn(String s) {
        LoggingServlet.getLog().add(new Date(System.currentTimeMillis()).toString() + " " + s);
        LoggingServlet.getLog().add("<br/>");
        jlog.warn(s);
    }

    public static void clear() {
        LoggingServlet.getLog().clear();
    }

    public static void error(String s, Exception e) {
        LoggingServlet.getLog().add(new Date(System.currentTimeMillis()).toString() + " " + s);
        LoggingServlet.getLog().add(new Date(System.currentTimeMillis()).toString() + " " + e.getMessage());
        LoggingServlet.getLog().add("<br/>");
        jlog.error(s, (Throwable)e);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=utf-8");
        StringBuffer s = new StringBuffer();
        for (String aux : log) {
            s.append(aux);
        }
        response.getWriter().append(s);
    }
}

