/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.servlets;

import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.valens.bamboo.base.CoreComponentsAbstractServlet;
import org.valens.bamboo.conditions.ConditionEvaluator;
import org.valens.bamboo.conditions.ConditionType;
import org.valens.bamboo.configuration.TemplateConfigurator;
import org.valens.bamboo.entities.GenericBambooEntity;
import org.valens.bamboo.servlets.LoggingServlet;

@Scanned
public class GenericConfigurationPropagatorServlet
extends CoreComponentsAbstractServlet {
    @Autowired
    public GenericConfigurationPropagatorServlet(@ComponentImport PlanManager planManager, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport TaskConfigurationService taskConfigurationService, @ComponentImport BuildDefinitionManager buildDefinitionManager, @ComponentImport ArtifactDefinitionManager artifactDefinitionManager, @ComponentImport ServerLifecycleManager serverLifecycleManager, @ComponentImport DeploymentProjectService deploymentProjectService, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport VariableConfigurationService variableConfigurationService, @ComponentImport NotificationManager notificationManager, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport EnvironmentService environmentService, @ComponentImport EnvironmentTaskService environmentTaskService, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport EventPublisher eventPublisher, @ComponentImport ChainBranchManager chainBranchManager, @ComponentImport BandanaManager bandanaManager) {
        super(planManager, cachedPlanManager, pluginAccessor, transactionTemplate, taskConfigurationService, buildDefinitionManager, artifactDefinitionManager, serverLifecycleManager, deploymentProjectService, variableDefinitionManager, variableConfigurationService, notificationManager, licenseManager, environmentService, environmentTaskService, userManager, loginUriProvider, templateRenderer, eventPublisher, chainBranchManager, bandanaManager);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    @Override
    public void doGet(final HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        ArrayList<GenericBambooEntity> templates = new ArrayList<GenericBambooEntity>();
        ArrayList<GenericBambooEntity> plans = new ArrayList<GenericBambooEntity>();
        HashMap<String, Object> par = new HashMap<String, Object>();
        par.put("trigger", (Object)this);
        par.put("requesttype", "config");
        HashMap configuration = new HashMap();
        if (this.getPlanManager() != null) {
            for (TopLevelPlan p : this.getPlanManager().getAllPlansUnrestricted()) {
                boolean state = true;
                if (p.getBuildDefinition().getCustomConfiguration().get(TemplateConfigurator.SELECTED_TEMPLATE_ENABLED) == null || ((String)p.getBuildDefinition().getCustomConfiguration().get(TemplateConfigurator.SELECTED_TEMPLATE_ENABLED)).toString().equalsIgnoreCase("false")) {
                    for (Job j : p.getAllJobs()) {
                        plans.add(new GenericBambooEntity(j.getKey(), j.getName()));
                    }
                }
                for (Job j : p.getAllJobs()) {
                    configuration.putAll(j.getBuildDefinition().getCustomConfiguration());
                }
            }
        }
        for (String s : configuration.keySet()) {
            templates.add(new GenericBambooEntity((String)configuration.get(s), s));
        }
        par.put("templates", templates);
        par.put("plans", plans);
        ConditionEvaluator eval = new ConditionEvaluator(this.getLicenseManager());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            this.getTemplateRenderer().render("templates/invalidLicense.vm", par, (Writer)response.getWriter());
        } else {
            this.getTemplateRenderer().render("templates/selectconfigitems.vm", par, (Writer)response.getWriter());
        }
        if (request.getParameter("submit-form") != null && request.getParameter("requesttype").equalsIgnoreCase("config")) {
            for (final String aux : request.getParameterValues("selectedplans")) {
                try {
                    LoggingServlet.warn("Setting value: " + request.getParameter("templateName") + " on environment " + aux);
                    this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

                        public Object doInTransaction() {
                            Job job = (Job)GenericConfigurationPropagatorServlet.this.getPlanManager().getPlanByKey(PlanKeys.getPlanKey((String)aux));
                            if (job == null) {
                                LoggingServlet.warn("Selected job was removed already !");
                            } else if (request.getParameter("configkey") != null && request.getParameter("configvalue") != null) {
                                BuildDefinition buildDefinition = job.getBuildDefinition();
                                buildDefinition.getCustomConfiguration().put(request.getParameter("configkey"), request.getParameter("configvalue"));
                                GenericConfigurationPropagatorServlet.this.getBuildDefinitionManager().savePlanAndDefinition((Plan)job, buildDefinition);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

