/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.servlets;

import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.valens.bamboo.base.CoreComponentsAbstractServlet;
import org.valens.bamboo.conditions.ConditionEvaluator;
import org.valens.bamboo.conditions.ConditionType;
import org.valens.bamboo.entities.TemplatedPlanEntity;

@Scanned
public class EnvironmentTemplatesReportServlet
extends CoreComponentsAbstractServlet {
    @Autowired
    public EnvironmentTemplatesReportServlet(@ComponentImport PlanManager planManager, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport TaskConfigurationService taskConfigurationService, @ComponentImport BuildDefinitionManager buildDefinitionManager, @ComponentImport ArtifactDefinitionManager artifactDefinitionManager, @ComponentImport ServerLifecycleManager serverLifecycleManager, @ComponentImport DeploymentProjectService deploymentProjectService, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport VariableConfigurationService variableConfigurationService, @ComponentImport NotificationManager notificationManager, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport EnvironmentService environmentService, @ComponentImport EnvironmentTaskService environmentTaskService, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport EventPublisher eventPublisher, @ComponentImport ChainBranchManager chainBranchManager, @ComponentImport BandanaManager bandanaManager) {
        super(planManager, cachedPlanManager, pluginAccessor, transactionTemplate, taskConfigurationService, buildDefinitionManager, artifactDefinitionManager, serverLifecycleManager, deploymentProjectService, variableDefinitionManager, variableConfigurationService, notificationManager, licenseManager, environmentService, environmentTaskService, userManager, loginUriProvider, templateRenderer, eventPublisher, chainBranchManager, bandanaManager);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        ArrayList<TemplatedPlanEntity> goodPlans = new ArrayList<TemplatedPlanEntity>();
        ArrayList<TemplatedPlanEntity> brokenPlans = new ArrayList<TemplatedPlanEntity>();
        ArrayList<TemplatedPlanEntity> notTemplated = new ArrayList<TemplatedPlanEntity>();
        HashMap<String, Object> par = new HashMap<String, Object>();
        par.put("trigger", (Object)this);
        par.put("eventText", "");
        List deploymentProjects = this.getDeploymentProjectService().getAllDeploymentProjects();
        for (DeploymentProject d : deploymentProjects) {
            for (Environment currentEnv : d.getEnvironments()) {
                List currentVariables = this.getVariableDefinitionManager().getDeploymentEnvironmentVariables(currentEnv.getId());
                boolean templated = false;
                List sourceVariables = this.getVariableDefinitionManager().getDeploymentEnvironmentVariables(currentEnv.getId());
                StringBuffer buf = new StringBuffer("Variables:");
                for (VariableDefinition v1 : sourceVariables) {
                    if (v1.getKey().toLowerCase().contains("password") || v1.getKey().toLowerCase().contains("secret")) continue;
                    buf.append("<div style='width: 300px'>" + v1.getKey() + "=" + v1.getValue() + "</div>");
                }
                for (VariableDefinition v : currentVariables) {
                    if (!v.getKey().equals("LINKED_TEMPLATE_ID")) continue;
                    templated = true;
                    List tasks = currentEnv.getTaskDefinitions();
                    Long envId = 0L;
                    if (v.getValue().matches("[0-9]*")) {
                        envId = Long.parseLong(v.getValue());
                    } else {
                        for (DeploymentProject p : this.getDeploymentProjectService().getAllDeploymentProjects()) {
                            for (Environment e : p.getEnvironments()) {
                                if (!v.getValue().equalsIgnoreCase(p.getName() + "/" + e.getName())) continue;
                                envId = e.getId();
                            }
                        }
                    }
                    Environment sourceEnv = this.getEnvironmentService().getEnvironment(envId.longValue());
                    if (sourceEnv != null) {
                        goodPlans.add(new TemplatedPlanEntity(d.getName() + "/" + currentEnv.getName(), this.getDeploymentProjectService().getDeploymentProject(sourceEnv.getDeploymentProjectId()).getName() + "/" + sourceEnv.getName(), "Template present", buf.toString()));
                        continue;
                    }
                    brokenPlans.add(new TemplatedPlanEntity(d.getName() + "/" + currentEnv.getName(), "" + envId, "Invalid - template missing", buf.toString()));
                }
                if (templated) continue;
                notTemplated.add(new TemplatedPlanEntity(d.getName() + "/" + currentEnv.getName(), "", "Not templated", buf.toString()));
            }
        }
        par.put("goodPlans", goodPlans);
        par.put("notTemplated", notTemplated);
        par.put("brokenPlans", brokenPlans);
        ConditionEvaluator eval = new ConditionEvaluator(this.getLicenseManager());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            this.getTemplateRenderer().render("templates/invalidLicense.vm", par, (Writer)response.getWriter());
        } else {
            this.getTemplateRenderer().render("templates/reports/template.envs.vm", par, (Writer)response.getWriter());
        }
    }
}

