/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.servlets;

import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.valens.bamboo.base.CoreComponentsAbstractServlet;
import org.valens.bamboo.conditions.ConditionEvaluator;
import org.valens.bamboo.conditions.ConditionType;
import org.valens.bamboo.events.BuildReplicationEvent;
import org.valens.bamboo.events.DeployReplicationEvent;

@Scanned
public class AdminServlet
extends CoreComponentsAbstractServlet {
    protected static final Logger log = LoggerFactory.getLogger(AdminServlet.class);

    @Autowired
    public AdminServlet(@ComponentImport PlanManager planManager, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport TaskConfigurationService taskConfigurationService, @ComponentImport BuildDefinitionManager buildDefinitionManager, @ComponentImport ArtifactDefinitionManager artifactDefinitionManager, @ComponentImport ServerLifecycleManager serverLifecycleManager, @ComponentImport DeploymentProjectService deploymentProjectService, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport VariableConfigurationService variableConfigurationService, @ComponentImport NotificationManager notificationManager, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport EnvironmentService environmentService, @ComponentImport EnvironmentTaskService environmentTaskService, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport EventPublisher eventPublisher, @ComponentImport ChainBranchManager chainBranchManager, @ComponentImport BandanaManager bandanaManager) {
        super(planManager, cachedPlanManager, pluginAccessor, transactionTemplate, taskConfigurationService, buildDefinitionManager, artifactDefinitionManager, serverLifecycleManager, deploymentProjectService, variableDefinitionManager, variableConfigurationService, notificationManager, licenseManager, environmentService, environmentTaskService, userManager, loginUriProvider, templateRenderer, eventPublisher, chainBranchManager, bandanaManager);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserKey username = this.getUserManager().getRemoteUserKey(request);
        if (username == null) {
            this.redirectToLogin(request, response);
            return;
        }
        Object o = this.getBandanaManager().getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "org.valens.system.header");
        if (!(o != null && o.toString().equalsIgnoreCase("true") || this.getUserManager().isSystemAdmin(username))) {
            this.redirectToLogin(request, response);
            return;
        }
        final String scr = request.getParameter("custom.bamboo.template.repl.depl");
        final HashMap<String, Object> par = new HashMap<String, Object>();
        par.put("trigger", (Object)this);
        par.put("eventText", "");
        boolean pause = "on".equalsIgnoreCase(request.getParameter("custom.bamboo.template.pause.server"));
        boolean permissions = "on".equalsIgnoreCase(request.getParameter("custom.bamboo.template.deploy.permissions"));
        boolean variables = "on".equalsIgnoreCase(request.getParameter("custom.bamboo.template.deploy.variables"));
        String tmp = "";
        if (pause) {
            tmp = tmp + " pause ";
        }
        if (permissions) {
            tmp = tmp + " permissions ";
        }
        if (variables) {
            tmp = tmp + " variables ";
        }
        if (scr != null && scr.contains("Replicate Deployments")) {
            par.put("eventText", "The event has been generated. replication was triggered.(" + tmp + ")");
            this.getEventPublisher().publish((Object)new DeployReplicationEvent(tmp));
        }
        final String tt = tmp;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (scr != null && scr.contains("Replicate Builds")) {
                    par.put("eventText", "The event has been generated. replication was triggered.(" + tt + ")");
                    AdminServlet.this.getEventPublisher().publish((Object)new BuildReplicationEvent(tt));
                }
            }
        });
        t.start();
        response.setContentType("text/html;charset=utf-8");
        ConditionEvaluator eval = new ConditionEvaluator(this.getLicenseManager());
        par.put("permissions", this.getPermissionsSetting());
        par.put("variables", this.getVariablesSetting());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            this.getTemplateRenderer().render("templates/invalidLicense.vm", par, (Writer)response.getWriter());
        } else {
            this.getTemplateRenderer().render("templates/operations.vm", par, (Writer)response.getWriter());
        }
    }
}

