/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.listeners;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.spring.container.ContainerManager;
import java.util.List;
import java.util.Map;

public class MergeHelpers {
    private BandanaManager bandanaManager;
    private String filter;

    public TaskDefinition locateTask(List<TaskDefinition> tasks, String description, TaskDefinition defaultv) {
        for (TaskDefinition t : tasks) {
            if (!t.getUserDescription().equalsIgnoreCase(description)) continue;
            return t;
        }
        return defaultv;
    }

    public TaskDefinition revertKeyFromOriginalTask(TaskDefinition origTask, TaskDefinition newTask) {
        if (this.getFilter().length() > 0) {
            for (String key : origTask.getConfiguration().keySet()) {
                if (!key.matches(this.getFilter())) continue;
                newTask.getConfiguration().put(key, (String)origTask.getConfiguration().get(key));
            }
        }
        return newTask;
    }

    public Map<String, String> revertKeyFromOriginalConfig(Map<String, String> origConfig, Map<String, String> newConfig) {
        if (this.getFilter().length() > 0) {
            for (String key : origConfig.keySet()) {
                if (!key.matches(this.getFilter())) continue;
                newConfig.put(key, origConfig.get(key));
            }
        }
        return newConfig;
    }

    public String getFilter() {
        this.filter = this.getValueAsString("org.valens.filter");
        if (this.filter == null) {
            this.filter = "";
        }
        return this.filter;
    }

    public String getValueAsString(String key) {
        Object o = this.getBandanaManager().getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            return "";
        }
        return (String)o;
    }

    public BandanaManager getBandanaManager() {
        return (BandanaManager)ContainerManager.getComponent((String)"bandanaManager");
    }
}

