/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.listeners;

import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskConditionConfigImpl;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.valens.bamboo.listeners.MergeHelpers;
import org.valens.bamboo.listeners.TaskDefinitionValidator;
import org.valens.bamboo.servlets.LoggingServlet;

public class MergeBuildTasksEngine {
    private static int CLASS_1_MERGE_ENGINE = 1;
    private static int CLASS_2_MERGE_ENGINE = 2;
    private int engineType = 0;
    MergeHelpers helpers = new MergeHelpers();

    public MergeBuildTasksEngine(int engineType) {
        this.engineType = engineType;
    }

    public List<TaskDefinition> merge(List<TaskDefinition> tasks, List<TaskDefinition> lst, boolean stateStates) {
        if (this.engineType == CLASS_1_MERGE_ENGINE) {
            return this.merge_class_1(tasks, lst, stateStates);
        }
        return this.merge_class_2(tasks, lst, stateStates);
    }

    private List<TaskDefinition> merge_class_1(List<TaskDefinition> tasks, List<TaskDefinition> lst, boolean stateStates) {
        long taskId;
        LinkedList<TaskDefinition> newTasks = new LinkedList<TaskDefinition>();
        if (!TaskDefinitionValidator.validate(lst)) {
            LoggingServlet.warn("Template task list is not valid. Merge aborted !");
            return tasks;
        }
        HashMap<String, Boolean> stateCache = new HashMap<String, Boolean>();
        for (TaskDefinition t : tasks) {
            if (t.getPluginKey().contains("task.vcs.checkout") || t.getPluginKey().contains("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin")) {
                taskId = TaskConfigurationUtils.getUniqueId(newTasks);
                TaskDefinitionImpl auxtask = new TaskDefinitionImpl(taskId, t.getPluginKey(), t.getUserDescription(), t.isEnabled(), t.getConfiguration(), t.isFinalising(), t.getRootDirectorySelector());
                auxtask.setFinalising(t.isFinalising());
                newTasks.add((TaskDefinition)auxtask);
            }
            stateCache.put(t.getUserDescription(), t.isEnabled());
        }
        for (TaskDefinition t : lst) {
            if (t.getPluginKey().contains("task.vcs.checkout") || t.getPluginKey().contains("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin")) continue;
            taskId = TaskConfigurationUtils.getUniqueId(newTasks);
            boolean b = t.isEnabled();
            if (stateStates && t.getUserDescription() != null && t.getUserDescription().length() > 0 && stateCache.get(t.getUserDescription()) != null) {
                b = (Boolean)stateCache.get(t.getUserDescription());
            }
            TaskDefinitionImpl auxtask = new TaskDefinitionImpl(taskId, t.getPluginKey(), t.getUserDescription(), b, t.getConfiguration(), t.isFinalising(), t.getRootDirectorySelector());
            ArrayList<TaskConditionConfigImpl> al = new ArrayList<TaskConditionConfigImpl>();
            for (TaskConditionConfig x : t.getConditions()) {
                TaskConditionConfigImpl ax = new TaskConditionConfigImpl(x.getConditionPluginKey(), x.getConfiguration());
                LoggingServlet.warn("    adding condition for " + t.getUserDescription());
                al.add(ax);
            }
            auxtask.setConditions(al);
            auxtask = this.helpers.revertKeyFromOriginalTask(this.helpers.locateTask(tasks, t.getUserDescription(), (TaskDefinition)auxtask), (TaskDefinition)auxtask);
            auxtask.setFinalising(t.isFinalising());
            LoggingServlet.debug("Generated new task: " + auxtask.toString());
            newTasks.add((TaskDefinition)auxtask);
        }
        return newTasks;
    }

    private List<TaskDefinition> merge_class_2(List<TaskDefinition> tasks, List<TaskDefinition> lst, boolean stateStates) {
        LinkedList<TaskDefinition> newTasks = new LinkedList<TaskDefinition>();
        if (!TaskDefinitionValidator.validate(lst)) {
            LoggingServlet.warn("Template task list is not valid. Merge aborted !");
            return tasks;
        }
        HashMap<String, Boolean> stateCache = new HashMap<String, Boolean>();
        for (TaskDefinition t : tasks) {
            stateCache.put("" + t.getUserDescription(), t.isEnabled());
        }
        for (TaskDefinition t : lst) {
            long taskId = TaskConfigurationUtils.getUniqueId(newTasks);
            boolean b = t.isEnabled();
            if (stateStates && t.getUserDescription() != null && t.getUserDescription().length() > 0 && stateCache.get("" + t.getUserDescription()) != null) {
                b = (Boolean)stateCache.get(t.getUserDescription());
            }
            Map configuration = t.getConfiguration();
            for (TaskDefinition tt : tasks) {
                if (tt.getPluginKey() != t.getPluginKey() || !("" + t.getUserDescription()).equalsIgnoreCase("" + tt.getUserDescription())) continue;
                if (t.getPluginKey().contains("task.vcs.checkout") || t.getPluginKey().contains("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin")) {
                    configuration = tt.getConfiguration();
                    continue;
                }
                configuration = t.getConfiguration();
            }
            TaskDefinitionImpl auxtask = new TaskDefinitionImpl(taskId, t.getPluginKey(), t.getUserDescription(), b, configuration);
            auxtask = this.helpers.revertKeyFromOriginalTask(this.helpers.locateTask(tasks, t.getUserDescription(), (TaskDefinition)auxtask), (TaskDefinition)auxtask);
            auxtask.setFinalising(t.isFinalising());
            ArrayList<TaskConditionConfigImpl> al = new ArrayList<TaskConditionConfigImpl>();
            for (TaskConditionConfig x : t.getConditions()) {
                TaskConditionConfigImpl ax = new TaskConditionConfigImpl(x.getConditionPluginKey(), x.getConfiguration());
                LoggingServlet.warn("    adding condition for " + t.getUserDescription());
                al.add(ax);
            }
            auxtask.setConditions(al);
            LoggingServlet.debug("Generated new task: " + auxtask.toString());
            newTasks.add((TaskDefinition)auxtask);
        }
        return newTasks;
    }
}

