/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.listeners;

import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.deployments.environments.ConfigurationState;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.requirement.EnvironmentRequirementService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.requirement.RequirementDetails;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.MutableAcl;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.valens.bamboo.conditions.ConditionEvaluator;
import org.valens.bamboo.conditions.ConditionType;
import org.valens.bamboo.events.DeployReplicationEvent;
import org.valens.bamboo.listeners.MergeHelpers;
import org.valens.bamboo.listeners.TaskDefinitionValidator;
import org.valens.bamboo.listeners.TemplateConfigurationListener;
import org.valens.bamboo.servlets.LoggingServlet;

@Scanned
public class DeploymentConfigurationListener
extends TemplateConfigurationListener {
    String sync = "";

    @Autowired
    public DeploymentConfigurationListener(@ComponentImport PlanManager planManager, @ComponentImport ImmutablePlanCacheService immutablePlanCacheService, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport TaskConfigurationService taskConfigurationService, @ComponentImport BuildDefinitionManager buildDefinitionManager, @ComponentImport ArtifactDefinitionManager artifactDefinitionManager, @ComponentImport ServerLifecycleManager serverLifecycleManager, @ComponentImport DeploymentProjectService deploymentProjectService, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport VariableConfigurationService variableConfigurationService, @ComponentImport NotificationManager notificationManager, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport EnvironmentService environmentService, @ComponentImport EnvironmentTaskService environmentTaskService, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport EventPublisher eventPublisher, @ComponentImport ChainBranchManager chainBranchManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport TriggerConfigurationService triggerConfigurationService, @ComponentImport TriggerTypeManager triggerTypeManager, @ComponentImport EnvironmentRequirementService EnvironmentRequirementService2, @ComponentImport BambooAuthenticationContext authenticationContext, @ComponentImport HibernateMutableAclService aclService, @ComponentImport ArtifactSubscriptionManager artifactSubscriptionManager) {
        super(planManager, immutablePlanCacheService, cachedPlanManager, pluginAccessor, transactionTemplate, taskConfigurationService, buildDefinitionManager, artifactDefinitionManager, serverLifecycleManager, deploymentProjectService, variableDefinitionManager, variableConfigurationService, notificationManager, licenseManager, environmentService, environmentTaskService, userManager, loginUriProvider, templateRenderer, eventPublisher, chainBranchManager, bandanaManager, triggerConfigurationService, triggerTypeManager, EnvironmentRequirementService2, authenticationContext, aclService, artifactSubscriptionManager);
    }

    public void replicateAllDeploymentProjects(DeployReplicationEvent event) {
        MergeHelpers helpers = new MergeHelpers();
        List deploymentProjects = this.getDeploymentProjectService().getAllDeploymentProjects();
        boolean permissions = false;
        if (event.getSource().toString().contains("permissions")) {
            permissions = true;
        }
        boolean variables = false;
        if (event.getSource().toString().contains("variables")) {
            variables = true;
        }
        LoggingServlet.clear();
        for (DeploymentProject d : deploymentProjects) {
            for (Environment currentEnv : d.getEnvironments()) {
                List currentVariables = this.getVariableDefinitionManager().getDeploymentEnvironmentVariables(currentEnv.getId());
                block16: for (VariableDefinition v : currentVariables) {
                    if (!v.getKey().equals("LINKED_TEMPLATE_ID")) continue;
                    LoggingServlet.warn("Processing environment: " + currentEnv.getName());
                    LoggingServlet.warn("LINKED_TEMPLATE_ID: " + v.getValue());
                    boolean block_premissions = "true".equalsIgnoreCase(this.getPermissionsSetting());
                    boolean block_variables = "true".equalsIgnoreCase(this.getVariablesSetting());
                    for (VariableDefinition vv : currentVariables) {
                        if (vv.getKey().equals("BLOCK_PERMISSION_REPLICATION") && vv.getValue().equalsIgnoreCase("true")) {
                            block_premissions = true;
                        }
                        if (!vv.getKey().equals("BLOCK_VARIABLE_OVERWRITING") || !vv.getValue().equalsIgnoreCase("true")) continue;
                        block_variables = true;
                    }
                    LoggingServlet.warn("Permissions BLOCKING: " + block_premissions);
                    LoggingServlet.warn("Variable BLOCKING: " + block_variables);
                    List tasks = currentEnv.getTaskDefinitions();
                    Long envId = 0L;
                    if (v.getValue().matches("[0-9]*")) {
                        envId = Long.parseLong(v.getValue());
                    } else {
                        for (DeploymentProject p : this.getDeploymentProjectService().getAllDeploymentProjects()) {
                            for (Environment e : p.getEnvironments()) {
                                if (!v.getValue().equalsIgnoreCase(p.getName() + "/" + e.getName())) continue;
                                envId = e.getId();
                            }
                        }
                    }
                    Environment sourceEnv = this.getEnvironmentService().getEnvironment(envId.longValue());
                    if (sourceEnv == null) {
                        LoggingServlet.debug("Source environment not found !" + envId);
                        continue;
                    }
                    try {
                        List sourceVariables = this.getVariableDefinitionManager().getDeploymentEnvironmentVariables(sourceEnv.getId());
                        for (VariableDefinition v1 : sourceVariables) {
                            if (!v1.getKey().equals("IS_TEMPLATE") || !v1.getValue().equalsIgnoreCase("Yes")) continue;
                            try {
                                for (VariableDefinition auxvar : sourceVariables) {
                                    if (auxvar.getKey().equalsIgnoreCase("IS_TEMPLATE") || auxvar.getKey().equalsIgnoreCase("LINKED_TEMPLATE_ID")) continue;
                                    LoggingServlet.debug("Process Variable: " + auxvar.getKey());
                                    boolean exist = false;
                                    for (VariableDefinition auxv : currentVariables) {
                                        if (!auxv.getKey().equalsIgnoreCase(auxvar.getKey())) continue;
                                        exist = true;
                                        if (!variables || block_variables) continue;
                                        String tmp = auxv.getValue();
                                        auxv.setValue(auxvar.getValue());
                                        this.getVariableConfigurationService().updateVariableDefinition(auxv, tmp);
                                    }
                                    if (exist) continue;
                                    this.getVariableConfigurationService().createVariableForEnvironment(currentEnv.getId(), auxvar.getKey(), auxvar.getValue());
                                }
                            }
                            catch (Exception ex) {
                                LoggingServlet.error("VariableDefinition validation exception:", ex);
                            }
                            List lst = sourceEnv.getTaskDefinitions();
                            String uniqueArtifactId = "-1";
                            if (lst.size() <= 0 || !TaskDefinitionValidator.validate(lst)) continue block16;
                            HashMap<String, Boolean> stateCache = new HashMap<String, Boolean>();
                            for (TaskDefinition t : tasks) {
                                this.getEnvironmentTaskService().deleteTask(currentEnv.getId(), t.getId());
                                if (t.getPluginKey().contains("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask")) {
                                    uniqueArtifactId = (String)t.getConfiguration().get("artifactId_0");
                                }
                                stateCache.put(t.getUserDescription(), t.isEnabled());
                            }
                            Long beforeId = 0L;
                            Long afterId = 0L;
                            for (TaskDefinition t : lst) {
                                boolean b = t.isEnabled();
                                if (t.getUserDescription() != null && t.getUserDescription().length() > 0 && stateCache.get(t.getUserDescription()) != null) {
                                    b = (Boolean)stateCache.get(t.getUserDescription());
                                }
                                Map config = t.getConfiguration();
                                if (t.getPluginKey().contains("com.atlassian.bamboo.plugins.deploy.continuous-plugin-deployment:deploy-task")) {
                                    String[] data = ((String)config.get("confDeployJar")).split(":", 5);
                                    data[1] = uniqueArtifactId;
                                    config.put("confDeployJar", String.format("%s:%s:%s:%s:%s", data[0], data[1], data[2], data[3], data[4]));
                                }
                                if (t.getPluginKey().contains("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin") || t.getPluginKey().contains("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask")) {
                                    for (TaskDefinition tt : tasks) {
                                        if (tt.getPluginKey() != t.getPluginKey() || !("" + t.getUserDescription()).equalsIgnoreCase("" + tt.getUserDescription())) continue;
                                        config = tt.getConfiguration();
                                    }
                                }
                                TaskModuleDescriptor taskDescriptor = this.getTaskDescriptor(t.getPluginKey());
                                config = helpers.revertKeyFromOriginalConfig(helpers.locateTask(tasks, t.getUserDescription(), t).getConfiguration(), config);
                                TaskDefinition def = this.getEnvironmentTaskService().createTask(currentEnv.getId(), taskDescriptor, t.getUserDescription(), b, config);
                                def.setRootDirectorySelector(t.getRootDirectorySelector());
                                if (!t.isFinalising()) {
                                    afterId = def.getId();
                                } else if (beforeId == 0L) {
                                    beforeId = def.getId();
                                }
                                LoggingServlet.debug("Creating task: " + t.getPluginKey() + " " + t.getId() + " " + t.getPluginKey() + " " + t.getUserDescription() + " " + t.getConfiguration());
                            }
                            this.getEnvironmentTaskService().moveFinalBar(currentEnv.getId(), afterId.longValue(), beforeId.longValue());
                            try {
                                List sourceRequirementSet = null;
                                List targetRequirementSet = null;
                                try {
                                    sourceRequirementSet = this.getEnvironmentRequirementService().getRequirementsForEnvironment(sourceEnv.getId());
                                    targetRequirementSet = this.getEnvironmentRequirementService().getRequirementsForEnvironment(currentEnv.getId());
                                }
                                catch (WebValidationException ex) {
                                    Logger.getLogger(DeploymentConfigurationListener.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                for (RequirementDetails requirement : targetRequirementSet) {
                                    try {
                                        this.getEnvironmentRequirementService().removeRequirement(currentEnv.getId(), requirement.getId());
                                    }
                                    catch (WebValidationException ex) {
                                        Logger.getLogger(DeploymentConfigurationListener.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                                for (RequirementDetails requirement : sourceRequirementSet) {
                                    try {
                                        this.getEnvironmentRequirementService().addRequirement(currentEnv.getId(), requirement.getKey(), requirement.getTypeOfMatch(), requirement.getMatchValue());
                                    }
                                    catch (WebValidationException ex) {
                                        Logger.getLogger(DeploymentConfigurationListener.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                Logger.getLogger(DeploymentConfigurationListener.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            NotificationSet clonedNotificationSet = this.getNotificationManager().cloneNotificationSet(this.getEnvironmentService().getNotificationSet(sourceEnv.getId()));
                            Set snr = clonedNotificationSet.getNotificationRules();
                            for (NotificationRule nr : snr) {
                                try {
                                    LoggingServlet.debug("Process Notification: " + nr.getRecipient());
                                    this.getEnvironmentService().addNotification(currentEnv.getId(), nr);
                                }
                                catch (WebValidationException ex) {
                                    LoggingServlet.error("Notification validation exception:", (Exception)((Object)ex));
                                }
                            }
                            if (permissions && !block_premissions) {
                                User user = this.getAuthenticationContext().getUser();
                                MutableAcl sourceAcl = this.getAclService().readMutableAclById(sourceEnv.getId());
                                LoggingServlet.warn("Processing environment permissions: " + currentEnv.getId());
                                MutableAcl acl = this.getAclService().readMutableAclById(currentEnv.getId());
                                for (AccessControlEntry ace : acl.getEntries()) {
                                    acl.deleteAce(ace.getId());
                                }
                                for (AccessControlEntry ace : sourceAcl.getEntries()) {
                                    acl.insertAce(null, ace.getPermission(), ace.getSid(), ace.isGranting());
                                }
                                this.getAclService().updateAcl(acl);
                            }
                            this.getEnvironmentService().updateEnvironmentConfigurationState(currentEnv.getId(), ConfigurationState.TASKED);
                            LoggingServlet.warn("Final Task List Size: " + currentEnv.getTaskDefinitions().size());
                        }
                    }
                    catch (Exception e) {
                        LoggingServlet.error("A general error occured:", e);
                    }
                }
            }
        }
    }

    @Override
    public TaskModuleDescriptor getTaskDescriptor(@Nullable String pluginKey) {
        if (StringUtils.isNotEmpty((CharSequence)pluginKey)) {
            ModuleDescriptor descriptor = this.getPluginAccessor().getEnabledPluginModule(pluginKey);
            return (TaskModuleDescriptor)Narrow.reinterpret((Object)descriptor, TaskModuleDescriptor.class);
        }
        return null;
    }

    @EventListener
    public void handleEvent(DeployReplicationEvent event) {
        LoggingServlet.warn("DeployReplicationEvent ");
        ConditionEvaluator eval = new ConditionEvaluator(this.getLicenseManager());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            return;
        }
        if (event instanceof DeployReplicationEvent) {
            this.replicateAllDeploymentProjects(event);
        }
    }
}

