/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.listeners;

import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.ServerLifecycleState;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.deployments.environments.requirement.EnvironmentRequirementService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTaskService;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.ChainCreatedEvent;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSetImpl;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.valens.bamboo.conditions.ConditionEvaluator;
import org.valens.bamboo.conditions.ConditionType;
import org.valens.bamboo.events.BuildReplicationEvent;
import org.valens.bamboo.listeners.DockerAgentMergingEngine;
import org.valens.bamboo.listeners.MergeBuildTasksEngine;
import org.valens.bamboo.listeners.TemplateConfigurationListener;
import org.valens.bamboo.listeners.TriggerMergingEngine;
import org.valens.bamboo.listeners.VariableMergingEngine;
import org.valens.bamboo.servlets.LoggingServlet;

@Scanned
public class BuildConfigurationListener
extends TemplateConfigurationListener {
    String sync = "";
    boolean overwriteArtifacts = false;
    HashMap<Job, Job> replications = new HashMap();
    private TaskManager taskManager;

    @Autowired
    public BuildConfigurationListener(@ComponentImport PlanManager planManager, @ComponentImport ImmutablePlanCacheService immutablePlanCacheService, @ComponentImport CachedPlanManager cachedPlanManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport TaskConfigurationService taskConfigurationService, @ComponentImport BuildDefinitionManager buildDefinitionManager, @ComponentImport ArtifactDefinitionManager artifactDefinitionManager, @ComponentImport ServerLifecycleManager serverLifecycleManager, @ComponentImport DeploymentProjectService deploymentProjectService, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport VariableConfigurationService variableConfigurationService, @ComponentImport NotificationManager notificationManager, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport EnvironmentService environmentService, @ComponentImport EnvironmentTaskService environmentTaskService, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport EventPublisher eventPublisher, @ComponentImport ChainBranchManager chainBranchManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport TriggerConfigurationService triggerConfigurationService, @ComponentImport TriggerTypeManager triggerTypeManager, @ComponentImport EnvironmentRequirementService EnvironmentRequirementService2, @ComponentImport BambooAuthenticationContext authenticationContext, @ComponentImport HibernateMutableAclService aclService, @ComponentImport ArtifactSubscriptionManager artifactSubscriptionManager) {
        super(planManager, immutablePlanCacheService, cachedPlanManager, pluginAccessor, transactionTemplate, taskConfigurationService, buildDefinitionManager, artifactDefinitionManager, serverLifecycleManager, deploymentProjectService, variableDefinitionManager, variableConfigurationService, notificationManager, licenseManager, environmentService, environmentTaskService, userManager, loginUriProvider, templateRenderer, eventPublisher, chainBranchManager, bandanaManager, triggerConfigurationService, triggerTypeManager, EnvironmentRequirementService2, authenticationContext, aclService, artifactSubscriptionManager);
    }

    private ArtifactDefinition convertDefinition(ArtifactDefinition artifactDefinition, Job job) {
        ArtifactDefinitionImpl definition = new ArtifactDefinitionImpl();
        definition.setName(artifactDefinition.getName());
        definition.setLocation(artifactDefinition.getLocation());
        definition.setCopyPattern(artifactDefinition.getCopyPattern());
        definition.setSharedArtifact(artifactDefinition.isSharedArtifact());
        definition.setProducerJob(job);
        return definition;
    }

    private String printDefinition(ArtifactDefinition artifactDefinition) {
        String s = artifactDefinition.getName() + " " + artifactDefinition.getLocation() + " " + artifactDefinition.getCopyPattern();
        return s;
    }

    private void logMap(Map map) {
        LoggingServlet.debug(map.toString());
        for (Object s : map.keySet()) {
            LoggingServlet.debug("[" + s + "] = [" + map.get(s) + "]");
        }
    }

    private boolean checkRequiment(RequirementSet rs, Requirement r) {
        boolean duplicate = false;
        for (Requirement aux : rs.getRequirements()) {
            if (!aux.getKey().equals(r.getKey()) || aux.belongsToPlugin()) continue;
            duplicate = true;
        }
        for (Requirement aux : rs.getRequirements()) {
            if (!aux.belongsToPlugin() || r.isRegexMatch() != aux.isRegexMatch() || r.getPluginModuleKey() != aux.getPluginModuleKey() || r.getTypeOfMatch() != aux.getTypeOfMatch() || r.getMatchValue() != aux.getMatchValue() || r.getKey() != aux.getKey() || r.getOwnerId() != aux.getOwnerId()) continue;
            duplicate = true;
        }
        return duplicate;
    }

    private boolean getSetting(Map<String, String> customConfiguration, String s) {
        boolean stateTask = true;
        if (customConfiguration.get(s) == null || customConfiguration.get(s).equalsIgnoreCase("false") || customConfiguration.get(s).length() == 0) {
            stateTask = false;
        }
        return stateTask;
    }

    private void mergeConfigurations(Job templateJob, Job job) {
        Map customConfiguration = job.getBuildDefinition().getCustomConfiguration();
        SecurityContextHolder.getContext().setAuthentication((Authentication)BambooPermissionManager.SYSTEM_AUTHORITY);
        this.overwriteArtifacts = this.getSetting(customConfiguration, "org.valens.artifacts");
        boolean stateTask = this.getSetting(customConfiguration, "custom.bamboo.template.task");
        boolean stateVars = this.getSetting(customConfiguration, "custom.bamboo.template.variables");
        boolean stateTriggers = this.getSetting(customConfiguration, "custom.bamboo.template.triggers");
        boolean stateDocker = this.getSetting(customConfiguration, "custom.bamboo.template.docker");
        boolean stateArtifacts = this.getSetting(customConfiguration, "custom.bamboo.template.artifacts");
        boolean stateStates = this.getSetting(customConfiguration, "custom.bamboo.template.states");
        boolean stateRequirements = this.getSetting(customConfiguration, "custom.bamboo.template.requirements");
        boolean config = this.getSetting(customConfiguration, "custom.bamboo.template.config");
        int stateOrder = 2;
        if (customConfiguration.get("custom.bamboo.template.order") == null || ((String)customConfiguration.get("custom.bamboo.template.order")).equalsIgnoreCase("false") || ((String)customConfiguration.get("custom.bamboo.template.order")).length() == 0) {
            stateOrder = 1;
        }
        BuildDefinition bd = job.getBuildDefinition();
        List tasks = bd.getTaskDefinitions();
        List<Object> newTasks = new LinkedList();
        List templateTaskDefinition = templateJob.getBuildDefinition().getTaskDefinitions();
        RequirementSetImpl rs = new RequirementSetImpl();
        RequirementSet requirementSetToClone = job.getRequirementSet();
        for (Requirement requirement : requirementSetToClone.getRequirements()) {
            if (requirement.belongsToPlugin()) continue;
            RequirementImpl newRequirement = new RequirementImpl(requirement);
            rs.addRequirement((Requirement)newRequirement);
        }
        if (stateTriggers) {
            TriggerMergingEngine.MergeBuildTriggers(templateJob, job, this.getTriggerConfigurationService(), this.getTriggerTypeManager());
            this.getPlanManager().savePlan((Plan)job.getParent());
        }
        MergeBuildTasksEngine eng = new MergeBuildTasksEngine(stateOrder);
        newTasks = stateTask ? eng.merge(tasks, templateTaskDefinition, stateStates) : tasks;
        HashMap<Long, String> templateTaskIds = new HashMap<Long, String>();
        HashMap<Long, String> jobTaskIds = new HashMap<Long, String>();
        HashMap<String, Long> newTaskIds = new HashMap<String, Long>();
        for (TaskDefinition taskDefinition : templateTaskDefinition) {
            templateTaskIds.put(taskDefinition.getId(), taskDefinition.getUserDescription());
        }
        for (TaskDefinition taskDefinition : tasks) {
            jobTaskIds.put(taskDefinition.getId(), taskDefinition.getUserDescription());
        }
        for (TaskDefinition taskDefinition : newTasks) {
            newTaskIds.put(taskDefinition.getUserDescription(), taskDefinition.getId());
        }
        requirementSetToClone = templateJob.getRequirementSet();
        for (Requirement requirement : requirementSetToClone.getRequirements()) {
            if (requirement.belongsToPlugin() || this.checkRequiment((RequirementSet)rs, requirement)) continue;
            RequirementImpl newRequirement = new RequirementImpl(requirement);
            rs.addRequirement((Requirement)newRequirement);
        }
        if (stateDocker) {
            DockerAgentMergingEngine.merge(templateJob.getBuildDefinition(), bd);
            this.getBuildDefinitionManager().savePlanAndDefinition((Plan)job, job.getBuildDefinition());
        }
        if (config) {
            this.logMap(templateJob.getBuildDefinition().getCustomConfiguration());
            for (String string : templateJob.getBuildDefinition().getCustomConfiguration().keySet()) {
                if (string.contains("custom.bamboo.template")) continue;
                String value = (String)templateJob.getBuildDefinition().getCustomConfiguration().get(string);
                bd.getCustomConfiguration().put(string, value);
            }
            this.logMap(job.getBuildDefinition().getCustomConfiguration());
        }
        if (stateRequirements || stateTask) {
            job.setRequirementSet((RequirementSet)rs);
        }
        if (stateTask) {
            bd.setTaskDefinitions(newTasks);
        }
        this.getBuildDefinitionManager().savePlanAndDefinition((Plan)job, bd);
        this.getImmutablePlanCacheService().cascadeInvalidate(job.getPlanKey());
        this.getEventPublisher().publish((Object)new BuildConfigurationUpdatedEvent((Object)this, job.getPlanKey()));
        this.getPlanManager().savePlan((Plan)job);
        tasks = job.getBuildDefinition().getTaskDefinitions();
        for (TaskDefinition taskDefinition : tasks) {
            this.getTaskManager().calculateRequirementsForTaskDefinition(job, taskDefinition);
            this.getBuildDefinitionManager().savePlanAndDefinition((Plan)job, job.getBuildDefinition());
        }
        if (stateVars) {
            VariableMergingEngine.MergeBuildVariables(templateJob, job, this.getVariableDefinitionManager(), this.getVariableConfigurationService());
        }
        ArrayList<ArtifactDefinition> artifacts = new ArrayList<ArtifactDefinition>();
        if (stateArtifacts) {
            if (this.overwriteArtifacts) {
                HashSet<String> hashSet = new HashSet<String>();
                List templateArtifacts = this.getArtifactDefinitionManager().findArtifactDefinitionsByPlan((ImmutablePlan)templateJob);
                List jobArtifacts = this.getArtifactDefinitionManager().findArtifactDefinitionsByPlan((ImmutablePlan)job);
                for (ArtifactDefinition artifact : jobArtifacts) {
                    String name;
                    if (artifact.getName().matches("(.*)-([a-zA-Z0-9]*)-([a-zA-Z0-9]*)-([a-zA-Z0-9]*)$")) {
                        name = artifact.getName().replaceAll("(.*)-([a-zA-Z0-9]*)-([a-zA-Z0-9]*)-([a-zA-Z0-9]*)$", "$1");
                        for (ArtifactDefinition auxArtifact : jobArtifacts) {
                            String auxname = auxArtifact.getName().replaceAll("(.*)-([a-zA-Z0-9]*)-([a-zA-Z0-9]*)-([a-zA-Z0-9]*)$", "$1");
                            if (artifact.getName().contains(job.getKey()) && auxArtifact.getName().contains(templateJob.getKey()) && auxname.equals(name)) {
                                this.getArtifactDefinitionManager().removeArtifactDefinition(auxArtifact);
                                hashSet.remove(name);
                                LoggingServlet.debug("Replacing " + auxArtifact.getName() + " with " + artifact.getName());
                            }
                            if (!auxArtifact.getName().equals(name)) continue;
                            this.getArtifactDefinitionManager().removeArtifactDefinition(auxArtifact);
                            hashSet.remove(name);
                            LoggingServlet.debug("Replacing " + auxArtifact.getName() + " with " + artifact.getName());
                        }
                        artifact.setName(name + "-" + job.getKey());
                    } else {
                        name = artifact.getName();
                        Iterator iterator = templateArtifacts.iterator();
                        while (iterator.hasNext()) {
                            ArtifactDefinition auxArtifact;
                            auxArtifact = (ArtifactDefinition)iterator.next();
                            String aname = artifact.getName().replace("-" + templateJob.getKey(), "");
                            if (!aname.equals(name)) continue;
                            artifact.setName(aname + "-" + job.getKey());
                        }
                    }
                    if (hashSet.contains(name)) {
                        this.getArtifactDefinitionManager().removeArtifactDefinition(artifact);
                        LoggingServlet.debug("Processing remove duplicate ArtifactDefinition from job " + artifact.toString());
                        continue;
                    }
                    ArtifactDefinition ad = this.getArtifactDefinitionManager().findArtifactDefinition((ImmutablePlan)templateJob, name + "-" + templateJob.getKey());
                    if (ad == null) {
                        ad = this.getArtifactDefinitionManager().findArtifactDefinition((ImmutablePlan)templateJob, name);
                    }
                    if (ad == null) continue;
                    artifacts.add(artifact);
                    hashSet.add(name);
                }
                Iterator iterator = templateArtifacts.iterator();
                while (iterator.hasNext()) {
                    ArtifactDefinition artifact;
                    artifact = (ArtifactDefinition)iterator.next();
                    try {
                        String aname = artifact.getName().replace("-" + templateJob.getKey(), "");
                        boolean ad = hashSet.contains(aname) || hashSet.contains(aname + "-" + job.getKey());
                        if (ad) continue;
                        String name = artifact.getName().replace("-" + templateJob.getKey(), "") + "-" + job.getKey();
                        if (!hashSet.contains(name)) {
                            ArtifactDefinition aux = this.convertDefinition(artifact, job);
                            aux.setName(name);
                            hashSet.add(aname);
                            artifacts.add(aux);
                            continue;
                        }
                        LoggingServlet.warn("Artifact definition not unique " + this.printDefinition(artifact));
                    }
                    catch (Exception e) {
                        LoggingServlet.error(e.getMessage(), e);
                    }
                }
                if (artifacts.size() == 0) {
                    this.getArtifactDefinitionManager().removeArtifactDefinitionsByPlan((Plan)job);
                } else {
                    this.getArtifactDefinitionManager().saveArtifactDefinitions(artifacts);
                }
            } else {
                artifacts = new ArrayList();
                HashSet<String> hashSet = new HashSet<String>();
                for (ArtifactDefinition artifact : job.getArtifactDefinitions()) {
                    ArtifactDefinition ad = this.getArtifactDefinitionManager().findArtifactDefinition((ImmutablePlan)templateJob, artifact.getName());
                    if (ad == null || hashSet.contains(artifact.getName())) continue;
                    artifacts.add(artifact);
                    hashSet.add(artifact.getName());
                }
                List artifacts1 = this.getArtifactDefinitionManager().findArtifactDefinitionsByPlan((ImmutablePlan)job);
                for (ArtifactDefinition artifact : templateJob.getArtifactDefinitions()) {
                    try {
                        ArtifactDefinition ad = this.getArtifactDefinitionManager().findArtifactDefinition((ImmutablePlan)job, artifact.getName());
                        if (ad == null) {
                            if (this.getArtifactDefinitionManager().isArtifactDefinitionNameUniqueInChain(artifact)) {
                                artifacts.add(this.convertDefinition(artifact, job));
                                continue;
                            }
                            LoggingServlet.warn("Artifact definition not unique " + this.printDefinition(artifact));
                            continue;
                        }
                        ad.setLocation(artifact.getLocation());
                        ad.setCopyPattern(artifact.getCopyPattern());
                        ad.setSharedArtifact(artifact.isSharedArtifact());
                    }
                    catch (Exception e) {
                        LoggingServlet.error(e.getMessage(), e);
                    }
                }
                if (artifacts.size() == 0) {
                    this.getArtifactDefinitionManager().removeArtifactDefinitionsByPlan((Plan)job);
                } else {
                    this.getArtifactDefinitionManager().saveArtifactDefinitions(artifacts);
                }
            }
        }
        LoggingServlet.warn(String.format("%30s", job.getBuildKey()) + " Tasks merge[" + stateTask + "] Tasks[" + job.getBuildDefinition().getTaskDefinitions().size() + "]Preserve states[ " + stateStates + "] Triggers[" + stateTriggers + "] Requirements[ " + stateRequirements + "]=>" + job.getRequirementSet().getRequirements().size() + " Artifacts[ " + stateArtifacts + "]=>" + artifacts.size() + " Docker[" + stateDocker + "]=>" + templateJob.getBuildDefinition().getDockerPipelineConfiguration().isEnabled() + " to " + job.getBuildDefinition().getDockerPipelineConfiguration().isEnabled());
    }

    public TaskManager getTaskManager() {
        if (this.taskManager == null) {
            this.taskManager = (TaskManager)ContainerManager.getComponent((String)"taskManager");
        }
        return this.taskManager;
    }

    private void doReplication(final String filterkey, final String jobFilter) {
        this.replications = new HashMap();
        this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                for (ImmutableTopLevelPlan planChain : BuildConfigurationListener.this.getCachedPlanManager().getPlansUnrestricted()) {
                    for (ImmutableChainStage stage : planChain.getAllStages()) {
                        for (ImmutableJob immutableJob : stage.getJobs()) {
                            BuildDefinition buildDefinition;
                            Map customConfiguration;
                            Job job = (Job)BuildConfigurationListener.this.getPlanManager().getPlanByKey(immutableJob.getPlanKey());
                            if (job == null || jobFilter != null && !jobFilter.equalsIgnoreCase(immutableJob.getKey()) || !(customConfiguration = (buildDefinition = job.getBuildDefinition()).getCustomConfiguration()).containsKey("custom.bamboo.template.list") || !((String)customConfiguration.get("custom.bamboo.template.list")).contains("=")) continue;
                            String selectedKey = ((String)customConfiguration.get("custom.bamboo.template.list")).split("=")[1];
                            if (!selectedKey.contains(filterkey)) {
                                LoggingServlet.debug("Skipping plan as template is not matching filter " + filterkey);
                                continue;
                            }
                            String[] tokens = selectedKey.split("-");
                            String templateKey = tokens[0] + "-" + tokens[1];
                            PlanKey planKey = PlanKeys.getPlanKey((String)templateKey);
                            Chain templateChain = (Chain)BuildConfigurationListener.this.getPlanManager().getPlanByKey(planKey);
                            if (templateChain == null) continue;
                            for (ChainStage chainTemplateStage : templateChain.getStages()) {
                                for (Job templateJob : chainTemplateStage.getJobs()) {
                                    if (!selectedKey.trim().equalsIgnoreCase(templateJob.getKey().trim())) continue;
                                    BuildConfigurationListener.this.replications.put(job, templateJob);
                                }
                            }
                        }
                    }
                }
                return null;
            }
        });
        while (!this.replications.isEmpty()) {
            Job aux2;
            boolean onedone = false;
            HashSet<Job> deleted = new HashSet<Job>();
            Iterator<Object> iterator = this.replications.keySet().iterator();
            while (iterator.hasNext()) {
                aux2 = iterator.next();
                if (this.replications.get(this.replications.get(aux2)) != null && !deleted.contains(aux2)) continue;
                this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction() {
                        BuildConfigurationListener.this.mergeConfigurations(BuildConfigurationListener.this.replications.get(aux2), aux2);
                        return null;
                    }
                });
                LoggingServlet.warn("Replicated " + aux2.getKey() + " that has a template " + this.replications.get(aux2).getKey() + " still to do ... " + (this.replications.size() - deleted.size()));
                deleted.add(aux2);
                onedone = true;
            }
            if (!onedone && !this.replications.isEmpty() && (iterator = this.replications.keySet().iterator()).hasNext()) {
                aux2 = (Job)iterator.next();
                this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction() {
                        BuildConfigurationListener.this.mergeConfigurations(BuildConfigurationListener.this.replications.get(aux2), aux2);
                        return null;
                    }
                });
                deleted.add(aux2);
                onedone = true;
            }
            for (final Job aux2 : deleted) {
                this.replications.remove(aux2);
                LoggingServlet.warn("Completed replication " + aux2.getKey() + " left ... " + this.replications.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicateAllBuildProjects(Event event) {
        BuildReplicationEvent ev = (BuildReplicationEvent)event;
        if (event.getSource().toString().contains("artifacts")) {
            this.overwriteArtifacts = true;
        }
        boolean pause = true;
        LoggingServlet.warn("Received event: [" + ev.getSource().toString() + "]");
        if (!ev.getSource().toString().contains("pause")) {
            pause = false;
        }
        LoggingServlet.debug("System pause: " + pause);
        if (pause) {
            this.getServerLifecycleManager().pauseServer();
        }
        int k = 0;
        while (this.getServerLifecycleManager().getServerLifecycleState().equals((Object)ServerLifecycleState.PAUSING) && k++ < 300 && pause) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                LoggingServlet.error(ex.getMessage(), ex);
            }
        }
        String string = this.sync;
        synchronized (string) {
            try {
                this.doReplication("", null);
            }
            catch (Exception e) {
                LoggingServlet.error("Received BuildConfigurationUpdatedEvent error ", e);
            }
        }
        if (pause) {
            this.getServerLifecycleManager().resumeServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicateAllBuildProjects(PlanKey key, String jobFilter) {
        LoggingServlet.warn("Received replicateAllBuildProjects event  " + key + " job filter " + jobFilter);
        Plan p = this.getPlanManager().getPlanByKey(key);
        if (p instanceof DefaultJob) {
            p = ((DefaultJob)p).getParent();
        } else if (p == null) {
            return;
        }
        boolean state = true;
        boolean pause = true;
        BuildDefinition buildDefinition = p.getBuildDefinition();
        if (buildDefinition.getCustomConfiguration().get("custom.bamboo.template.enabled") == null || ((String)buildDefinition.getCustomConfiguration().get("custom.bamboo.template.enabled")).equalsIgnoreCase("false")) {
            state = false;
        }
        if (buildDefinition.getCustomConfiguration().get("custom.bamboo.template.pause.enabled") == null || ((String)buildDefinition.getCustomConfiguration().get("custom.bamboo.template.pause.enabled")).equalsIgnoreCase("false")) {
            pause = false;
        }
        if (state) {
            if (pause) {
                this.getServerLifecycleManager().pauseServer();
            }
            int k = 0;
            while (this.getServerLifecycleManager().getServerLifecycleState().equals((Object)ServerLifecycleState.PAUSING) && k++ < 300 && pause) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LoggingServlet.error(ex.getMessage(), ex);
                }
            }
            String string = this.sync;
            synchronized (string) {
                try {
                    this.doReplication(key.getKey(), jobFilter);
                }
                catch (Exception e) {
                    LoggingServlet.error("Received BuildConfigurationUpdatedEvent error ", e);
                }
            }
            if (pause) {
                this.getServerLifecycleManager().resumeServer();
            }
        }
    }

    @EventListener
    public void handleEvent(@NotNull ChainCreatedEvent event) {
        LoggingServlet.warn("ChainCreatedEvent " + event.toString());
        ConditionEvaluator eval = new ConditionEvaluator(this.getLicenseManager());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            return;
        }
        Chain templateChain = (Chain)this.getPlanManager().getPlanByKey(event.getPlanKey());
        if (templateChain == null) {
            return;
        }
        for (ChainStage chainTemplateStage : templateChain.getStages()) {
            for (Job templateJob : chainTemplateStage.getJobs()) {
                Plan p = this.getPlanManager().getPlanByKey(templateJob.getPlanKey());
                BuildDefinition buildDefinition = p.getBuildDefinition();
                Map customConfiguration = buildDefinition.getCustomConfiguration();
                LoggingServlet.warn("ChainCreatedEvent " + customConfiguration.toString());
                if (!customConfiguration.containsKey("custom.bamboo.template.list") || !((String)customConfiguration.get("custom.bamboo.template.list")).contains("=")) continue;
                String selectedKey = ((String)customConfiguration.get("custom.bamboo.template.list")).split("=")[1];
                LoggingServlet.warn("New plan created " + p.getKey() + " that has a template " + selectedKey);
                PlanKey planKey = PlanKeys.getPlanKey((String)selectedKey);
                this.replicateAllBuildProjects(planKey, p.getKey());
            }
        }
    }

    @EventListener
    public void handleEvent(@NotNull BuildReplicationEvent event) {
        LoggingServlet.warn("BuildReplicationEvent " + event.toString());
        this.replicateAllBuildProjects(event);
    }
}

