/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.configuration;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class TemplatesGlobalConfigurePlugin
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(TemplatesGlobalConfigurePlugin.class);
    private BandanaManager bandanaManager;
    private String templateSystem;
    private String filter;
    private String permissions;
    private String variables;
    private String artifacts;

    @Autowired
    public TemplatesGlobalConfigurePlugin(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public String getTemplateSystem() {
        if (this.templateSystem == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.templateSystem;
    }

    public void setTemplateSystem(String templateSystem) {
        this.templateSystem = templateSystem;
    }

    public String doDefault() throws Exception {
        this.templateSystem = this.getValueAsString("org.valens.system.header");
        this.filter = this.getValueAsString("org.valens.filter");
        this.variables = this.getValueAsString("org.valens.variables");
        this.permissions = this.getValueAsString("org.valens.permissions");
        this.artifacts = this.getValueAsString("org.valens.artifacts");
        return "input";
    }

    public String execute() throws Exception {
        this.setValue("org.valens.filter", this.filter);
        this.setValue("org.valens.system.header", this.templateSystem);
        this.setValue("org.valens.variables", this.variables);
        this.setValue("org.valens.permissions", this.permissions);
        this.setValue("org.valens.artifacts", this.artifacts);
        return "success";
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    private void setValue(String key, Object obj) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key, obj);
    }

    public String getValueAsString(String key) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            return "";
        }
        return (String)o;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getPermissions() {
        if (this.permissions == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getVariables() {
        if (this.variables == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.variables;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public String getArtifacts() {
        if (this.artifacts == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.artifacts;
    }

    public void setArtifacts(String artifacts) {
        this.artifacts = artifacts;
    }
}

