/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.configuration;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.configuration.MiscellaneousPlanConfigurationPlugin;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.v2.build.BaseBuildConfigurationAwarePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.valens.bamboo.events.ReloadCacheEvent;
import org.valens.bamboo.listeners.PlanCacheListener;

public class TemplateConfigurator
extends BaseBuildConfigurationAwarePlugin
implements MiscellaneousPlanConfigurationPlugin {
    @Inject
    private PlanManager planManager;
    @Inject
    private PluginLicenseManager licenseManager;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private PlanCacheListener planCacheListener;
    private TemplateRenderer templateRenderer;
    public static String SELECTED_TEMPLATE_ENABLED = "custom.bamboo.template.enabled";
    protected static final Logger log = LoggerFactory.getLogger(TemplateConfigurator.class);

    public boolean isApplicableTo(@NotNull ImmutablePlan immutablePlan) {
        return immutablePlan instanceof ImmutableJob;
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull BuildConfiguration bc, @Nullable Plan plan) {
        super.populateContextForEdit(context, bc, plan);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (String s : this.planCacheListener.getPlancache().keySet()) {
            result.put(s, this.planCacheListener.getPlancache().get(s));
        }
        if (result.size() == 0) {
            this.eventPublisher.publish((Object)new ReloadCacheEvent());
        }
        context.put("templates", result);
    }

    public PlanManager getPlanManager() {
        return this.planManager;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public TemplateRenderer getTemplateRenderer() {
        if (this.templateRenderer == null) {
            this.templateRenderer = (TemplateRenderer)ContainerManager.getComponent((String)"templateRenderer");
        }
        return this.templateRenderer;
    }

    public PluginLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Nullable
    public String getViewHtml(@NotNull Plan plan) {
        ResourceLocation resourceLocation = this.moduleDescriptor.getResourceLocation("freemarker", "view");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            HashMap<String, TemplateConfigurator> context = new HashMap<String, TemplateConfigurator>();
            context.put("plugin", this);
            context.put("build", (TemplateConfigurator)plan);
            context.put("plan", (TemplateConfigurator)plan);
            this.populateContextForView(context, plan);
            return this.getTemplateRenderer().render(templatePath, context);
        }
        return "";
    }

    @Nullable
    public String getEditHtml(@NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        ResourceLocation resourceLocation = this.moduleDescriptor.getResourceLocation("freemarker", "edit");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("plugin", (Object)this);
            context.put("build", plan);
            context.put("plan", plan);
            context.put("buildConfiguration", buildConfiguration);
            this.populateContextForEdit(context, buildConfiguration, plan);
            return this.getTemplateRenderer().render(templatePath, context);
        }
        return "";
    }
}

