/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.configuration;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plan.configuration.MiscellaneousPlanConfigurationPlugin;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.v2.build.BaseBuildConfigurationAwarePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.HashMap;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class TemplateAdminConfigurator
extends BaseBuildConfigurationAwarePlugin
implements MiscellaneousPlanConfigurationPlugin {
    protected static final Logger log = LoggerFactory.getLogger(TemplateAdminConfigurator.class);
    @Inject
    private PlanManager planManager;
    @Inject
    private PluginLicenseManager licenseManager;
    private TemplateRenderer templateRenderer;

    public boolean isApplicableTo(@NotNull ImmutablePlan immutablePlan) {
        return immutablePlan instanceof ImmutableTopLevelPlan;
    }

    public TemplateRenderer getTemplateRenderer() {
        if (this.templateRenderer == null) {
            this.templateRenderer = (TemplateRenderer)ContainerManager.getComponent((String)"templateRenderer");
        }
        return this.templateRenderer;
    }

    @Nullable
    public String getViewHtml(@NotNull Plan plan) {
        ResourceLocation resourceLocation = this.moduleDescriptor.getResourceLocation("freemarker", "view");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            HashMap<String, TemplateAdminConfigurator> context = new HashMap<String, TemplateAdminConfigurator>();
            context.put("plugin", this);
            context.put("build", (TemplateAdminConfigurator)plan);
            context.put("plan", (TemplateAdminConfigurator)plan);
            this.populateContextForView(context, plan);
            return this.getTemplateRenderer().render(templatePath, context);
        }
        return "";
    }

    @Nullable
    public String getEditHtml(@NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        ResourceLocation resourceLocation = this.moduleDescriptor.getResourceLocation("freemarker", "edit");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            HashMap<String, TemplateAdminConfigurator> context = new HashMap<String, TemplateAdminConfigurator>();
            context.put("plugin", this);
            context.put("build", (TemplateAdminConfigurator)plan);
            context.put("plan", (TemplateAdminConfigurator)plan);
            context.put("buildConfiguration", (TemplateAdminConfigurator)buildConfiguration);
            this.populateContextForEdit(context, buildConfiguration, plan);
            return this.getTemplateRenderer().render(templatePath, context);
        }
        return "";
    }
}

