/*
 * Decompiled with CFR 0.152.
 */
package org.valens.bamboo.conditions;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.valens.bamboo.conditions.ConditionType;

@Component
public class ConditionEvaluator {
    PluginLicenseManager licenseManager;

    @Autowired
    public ConditionEvaluator(@ComponentImport PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean evaluate(ConditionType type) {
        switch (type) {
            case LICENSED: {
                return this.isLicenseValid();
            }
        }
        return false;
    }

    private boolean isLicenseValid() {
        boolean isLicensed = false;
        boolean hasErrors = false;
        for (PluginLicense pluginLicense : this.licenseManager.getLicense()) {
            isLicensed = true;
            hasErrors = hasErrors || pluginLicense.getError().isDefined();
        }
        isLicensed = isLicensed && !hasErrors;
        return isLicensed;
    }
}

