/*
 * Decompiled with CFR 0.152.
 */
package com.appfire.bamboo.rest.license;

import com.appfire.bamboo.rest.AbstractResource;
import com.appfire.bamboo.rest.license.LicenseResponse;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.google.gson.Gson;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/validatelicense")
public class LicenseResource
extends AbstractResource {
    protected final BambooPermissionManager permissionManager;
    protected final UserManager userManager;
    protected final PluginLicenseManager pluginLicenseManager;

    public LicenseResource(PluginLicenseManager licenseManager, BambooLicenseManager bambooLicenseManager, I18nResolver i18nResolver, AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooPermissionManager permissionManager, UserManager userManager, PluginLicenseManager pluginLicenseManager) {
        super(licenseManager, bambooLicenseManager, i18nResolver, administrationConfigurationAccessor);
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json", "text/plain"})
    public Response getMessage(@QueryParam(value="option") String option) {
        return LicenseResource.buildResponse(this.validateLicense(option));
    }

    public LicenseResponse validateLicense(String option) {
        String reason = "UNKNOWN_ERROR";
        boolean licenseOk = this.licenseManager != null;
        LicenseResponse licenseResponse = new LicenseResponse();
        this.addServerInfo(licenseResponse, option);
        if (licenseOk) {
            try {
                PluginLicense pluginLicense;
                boolean bl = licenseOk = this.licenseManager.getLicense() != null && this.licenseManager.getLicense().isDefined();
                reason = licenseOk ? (!(licenseOk = (pluginLicense = (PluginLicense)this.licenseManager.getLicense().get()).isValid()) ? this.i18nResolver.getText(((LicenseError)pluginLicense.getError().get()).name()) : this.getText(".valid-license", new Serializable[0])) : this.getText(".no-license", new Serializable[0]);
            }
            catch (Exception exception) {
                this.log.error(exception.getMessage());
                licenseOk = false;
            }
        }
        if (!licenseOk && this.bambooLicenseManager.isDeveloper()) {
            reason = this.getText(".developer-license", new Serializable[0]);
            licenseOk = true;
        }
        if (!licenseOk) {
            reason = this.getText(".invalid-license", new Serializable[]{reason});
        }
        licenseResponse.setStatus(licenseOk);
        licenseResponse.setMessage(reason);
        if (this.log.isDebugEnabled()) {
            this.log.debug("License response message: {}", (Object)licenseResponse.getMessage());
        }
        return licenseResponse;
    }

    protected void addServerInfo(LicenseResponse licenseResponse, String option) {
        try {
            AdministrationConfiguration configuration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
            licenseResponse.setProduct("Bamboo");
            licenseResponse.setVersion(BuildUtils.getCurrentVersion());
            licenseResponse.setBuild(BuildUtils.getCurrentBuildNumber());
            licenseResponse.setBuildDate(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(BuildUtils.getCurrentBuildDate()));
            licenseResponse.setTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(System.currentTimeMillis()));
            licenseResponse.setTitle(configuration.getInstanceName());
            licenseResponse.setBaseUrl(configuration.getBaseUrl());
            BambooLicense hostLicense = this.bambooLicenseManager.getLicense();
            licenseResponse.setHosting(this.getHosting(hostLicense.isClusteringEnabled() || hostLicense.isSubscription()));
            if ("2".equals(option) && this.permissionManager.isAdmin(this.userManager.getRemoteUser().getUsername())) {
                licenseResponse.setSupportEntitlementNumber(this.getPluginSupportEntitlementNumber());
                LinkedHashMap<String, Object> licenseInfo = new LinkedHashMap<String, Object>();
                licenseInfo.put("description", hostLicense.getDescription());
                licenseInfo.put("type", hostLicense.getLicenseType().name());
                licenseInfo.put("maxLocalAgents", hostLicense.getMaximumNumberOfLocalAgents());
                licenseInfo.put("maxRemoteAgents", hostLicense.getMaximumNumberOfRemoteAgents());
                licenseInfo.put("maxPlans", hostLicense.getMaximumNumberOfPlans());
                licenseInfo.put("expiry", this.toJsonDate(hostLicense.getMaintenanceExpiryDate()));
                licenseInfo.put("evaluation", hostLicense.isEvaluation());
                licenseInfo.put("developer", hostLicense.getLicenseType().equals((Object)LicenseType.DEVELOPER));
                licenseInfo.put("supportEntitlementNumber", hostLicense.getSupportEntitlementNumber());
                licenseInfo.put("serverId", hostLicense.getServerId());
                licenseResponse.setLicenseInfo(licenseInfo);
            }
        }
        catch (Exception exception) {
            this.log.error("Unexpected exception retrieving server information: {}", (Throwable)exception);
        }
    }

    protected String getHosting(boolean isCluster) {
        return isCluster ? "datacenter" : "server";
    }

    protected String getPluginSupportEntitlementNumber() {
        String supportEntitlementNumber = "";
        try {
            PluginLicense pluginLicense;
            Option pluginLicenseOption = this.pluginLicenseManager.getLicense();
            if (pluginLicenseOption != null && pluginLicenseOption.isDefined() && (pluginLicense = (PluginLicense)pluginLicenseOption.get()) != null && pluginLicense.getSupportEntitlementNumber().isDefined()) {
                supportEntitlementNumber = (String)pluginLicense.getSupportEntitlementNumber().get();
            }
        }
        catch (Exception e) {
            this.log.debug("Error while capturing plugin information ", (Throwable)e);
        }
        return supportEntitlementNumber;
    }

    public static Response buildResponse(LicenseResponse licenseResponse) {
        String jsonResponse = LicenseResource.toJson(licenseResponse);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonResponse).build();
    }

    public static String toJson(Object object) {
        return new Gson().toJson(object);
    }

    protected String toJsonDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }
}

