/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.packageManager;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.packageManager.PackageManagerLogger;

public class PackageManagerUtils {
    private static final String apiKeySecretPrefix = "AKCp8";
    private static final int apiKeySecretMinimalLength = 73;
    private static final String referenceTokenSecretPrefix = "cmVmdGtuOjAxOj";
    private static final int referenceTokenSecretMinimalLength = 64;
    private static final String accessTokenSecretPrefix = "eyJ2ZXIiOiIyIiwidHlwIjoiSldUIiwiYWxnIjoiUlMyNTYiLCJraWQiOiJ";
    private static final int accessTokenSecretMinimalLength = 0;

    public static ArtifactoryClientConfiguration createArtifactoryClientConfiguration() {
        PackageManagerLogger log = new PackageManagerLogger();
        ArtifactoryClientConfiguration clientConfiguration = new ArtifactoryClientConfiguration(log);
        Properties allBuildProps = new Properties();
        allBuildProps.putAll(System.getenv());
        Properties allProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile(allBuildProps, log);
        clientConfiguration.fillFromProperties(allProps);
        return clientConfiguration;
    }

    public static String createArtifactoryUrlWithCredentials(String url, String username, String password, String path) throws MalformedURLException, URISyntaxException {
        URL rtUrl = new URL(url);
        URIBuilder proxyUrlBuilder = new URIBuilder().setScheme(rtUrl.getProtocol()).setUserInfo(username, password).setHost(rtUrl.getHost()).setPort(rtUrl.getPort()).setPath(rtUrl.getPath() + path);
        return proxyUrlBuilder.build().toURL().toString();
    }

    public static void collectEnvAndFilterProperties(ArtifactoryClientConfiguration clientConfiguration, BuildInfo buildInfo) {
        PackageManagerUtils.collectEnvIfNeeded(clientConfiguration, buildInfo);
        PackageManagerUtils.filterBuildInfoProperties(clientConfiguration, buildInfo, clientConfiguration.getLog());
    }

    private static void collectEnvIfNeeded(ArtifactoryClientConfiguration clientConfiguration, BuildInfo buildInfo) {
        if (!clientConfiguration.isIncludeEnvVars().booleanValue()) {
            return;
        }
        Properties envProperties = new Properties();
        envProperties.putAll(clientConfiguration.getAllProperties());
        envProperties = BuildInfoExtractorUtils.getEnvProperties(envProperties, clientConfiguration.getLog());
        if (buildInfo.getProperties() != null) {
            buildInfo.getProperties().putAll((Map<?, ?>)envProperties);
            return;
        }
        buildInfo.setProperties(envProperties);
    }

    public static void filterBuildInfoProperties(ArtifactoryClientConfiguration clientConfiguration, BuildInfo buildInfo, Log log) {
        String include = clientConfiguration.getEnvVarsIncludePatterns();
        String exclude = clientConfiguration.getEnvVarsExcludePatterns();
        IncludeExcludePatterns includeExcludePatterns = new IncludeExcludePatterns(include, exclude);
        PackageManagerUtils.filterExcludeIncludeProperties(includeExcludePatterns, buildInfo, log);
    }

    private static void filterExcludeIncludeProperties(IncludeExcludePatterns includePattern, BuildInfo buildInfo, Log log) {
        List<Module> modules;
        Properties props = buildInfo.getProperties();
        if (props != null && props.size() > 0) {
            Properties filteredProps = PackageManagerUtils.getExcludeIncludeProperties(includePattern, props, log);
            buildInfo.setProperties(filteredProps);
        }
        if ((modules = buildInfo.getModules()) == null || modules.size() == 0) {
            return;
        }
        for (Module module : modules) {
            Properties moduleProps = module.getProperties();
            if (moduleProps == null || moduleProps.size() <= 0) continue;
            module.setProperties(PackageManagerUtils.getExcludeIncludeProperties(includePattern, moduleProps, log));
        }
    }

    private static Properties getExcludeIncludeProperties(IncludeExcludePatterns patterns, Properties properties, Log log) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!PackageManagerUtils.isExcludedByKey(patterns, entry) && !PackageManagerUtils.containsSuspectedSecrets(entry.getValue().toString())) {
                props.put(entry.getKey(), entry.getValue());
                continue;
            }
            log.debug("[buildinfo] Property '" + entry.getKey() + "' has been excluded'");
        }
        return props;
    }

    private static boolean isExcludedByKey(IncludeExcludePatterns patterns, Map.Entry<Object, Object> entry) {
        return PatternMatcher.pathConflicts(entry.getKey().toString(), patterns);
    }

    public static boolean containsSuspectedSecrets(String value) {
        if (StringUtils.isBlank(value)) {
            return false;
        }
        return PackageManagerUtils.containsSuspectedSecret(value, apiKeySecretPrefix, 73) || PackageManagerUtils.containsSuspectedSecret(value, referenceTokenSecretPrefix, 64) || PackageManagerUtils.containsSuspectedSecret(value, accessTokenSecretPrefix, 0);
    }

    private static boolean containsSuspectedSecret(String variableValue, String secretPrefix, int secretMinimalLength) {
        return variableValue.startsWith(secretPrefix) && variableValue.length() >= secretMinimalLength;
    }
}

