/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.util.PathsUtils;
import org.jfrog.build.extractor.clientConfiguration.util.spec.UploadSpecHelper;

public class PublishedItemsHelper {
    public static Multimap<String, String> getPublishedItemsPatternPairs(String publishedItemsPropertyValue) {
        HashMultimap<String, String> patternPairMap = HashMultimap.create();
        if (StringUtils.isNotBlank(publishedItemsPropertyValue)) {
            List<String> patternPairs = PublishedItemsHelper.parsePatternsFromProperty(publishedItemsPropertyValue);
            for (String patternPair : patternPairs) {
                String[] splitPattern = patternPair.split("=>");
                String sourcePattern = "";
                String targetPattern = "";
                if (splitPattern.length > 0) {
                    sourcePattern = FilenameUtils.separatorsToUnix(splitPattern[0].trim());
                }
                if (splitPattern.length > 1) {
                    targetPattern = FilenameUtils.separatorsToUnix(splitPattern[1].trim());
                }
                if (!StringUtils.isNotBlank(sourcePattern)) continue;
                patternPairMap.put(sourcePattern, targetPattern);
            }
        }
        return patternPairMap;
    }

    public static List<String> parsePatternsFromProperty(String publishedItemsPropertyValue) {
        String[] newLineTokens;
        if (publishedItemsPropertyValue == null) {
            throw new IllegalArgumentException("Cannot parse null pattern.");
        }
        ArrayList<String> patterns = new ArrayList<String>();
        if (StringUtils.isEmpty(publishedItemsPropertyValue)) {
            return patterns;
        }
        for (String lineToken : newLineTokens = publishedItemsPropertyValue.split("\n")) {
            String[] commaTokens;
            if (!StringUtils.isNotBlank(lineToken)) continue;
            for (String commaToken : commaTokens = lineToken.trim().split(",")) {
                if (!StringUtils.isNotBlank(commaToken)) continue;
                patterns.add(commaToken.trim());
            }
        }
        return patterns;
    }

    public static String removeDoubleDotsFromPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Cannot remove double dots from a null pattern.");
        }
        if (!pattern.contains("..")) {
            return pattern;
        }
        String[] splitPattern = pattern.split("/");
        StringBuilder patternBuilder = new StringBuilder();
        if (pattern.startsWith("/")) {
            patternBuilder.append("/");
        }
        for (int i = 0; i < splitPattern.length; ++i) {
            if ("..".equals(splitPattern[i])) continue;
            patternBuilder.append(splitPattern[i]);
            if (i == splitPattern.length - 1) continue;
            patternBuilder.append("/");
        }
        return StringUtils.removeEnd(patternBuilder.toString(), "/");
    }

    @Deprecated
    public static Multimap<String, File> buildPublishingData(File checkoutDir, String pattern, String targetPath) throws IOException {
        HashMultimap<String, File> filePathsMap = HashMultimap.create();
        File patternAbsolutePath = PublishedItemsHelper.getAbsolutePath(checkoutDir, pattern);
        if (patternAbsolutePath.isFile()) {
            filePathsMap.put(targetPath, patternAbsolutePath);
        } else {
            Pattern filePattern = null;
            File patternDir = null;
            if (patternAbsolutePath.isDirectory()) {
                filePattern = Pattern.compile(".*");
                patternDir = patternAbsolutePath;
            } else if (pattern.indexOf(42) >= 0 || pattern.indexOf(63) >= 0) {
                String patternAbsolutePathUrl;
                File baseTruncationDir = PublishedItemsHelper.getBaseTruncationDir(patternAbsolutePath);
                patternDir = baseTruncationDir != null ? baseTruncationDir : checkoutDir;
                boolean isCheckoutDirAncestor = PublishedItemsHelper.isAncestor(checkoutDir, patternAbsolutePath);
                if (isCheckoutDirAncestor) {
                    pattern = pattern.substring(patternDir.getAbsolutePath().length() - checkoutDir.getAbsolutePath().length());
                }
                if (!StringUtils.isBlank(patternAbsolutePathUrl = patternAbsolutePath.getAbsolutePath()) && patternAbsolutePathUrl.startsWith(patternDir.getAbsolutePath())) {
                    pattern = UploadSpecHelper.getRelativePath(patternDir, patternAbsolutePath);
                }
                filePattern = Pattern.compile(PublishedItemsHelper.convertAntToRegexp(pattern));
            }
            if (filePattern != null) {
                ArrayList files = new ArrayList();
                PublishedItemsHelper.collectMatchedFiles(patternDir, patternDir, filePattern, files);
                for (File file : files) {
                    String fileTargetPath = UploadSpecHelper.calculateFileTargetPath(patternDir, file, targetPath);
                    filePathsMap.put(fileTargetPath, file);
                }
            }
        }
        return filePathsMap;
    }

    @Deprecated
    public static Multimap<String, File> wildCardBuildPublishingData(File checkoutDir, String pattern, String targetPath, boolean flat, boolean isRecursive, boolean regexp) {
        if (!regexp) {
            pattern = PathsUtils.pathToRegExp(pattern);
        }
        Pattern regexPattern = Pattern.compile(pattern);
        ArrayList<File> files = new ArrayList<File>();
        PublishedItemsHelper.collectMatchedFiles(checkoutDir, checkoutDir, regexPattern, files, isRecursive);
        return UploadSpecHelper.getUploadPathsMap(files, checkoutDir, targetPath, flat, regexPattern, false);
    }

    private static File getAbsolutePath(File baseDir, String pattern) {
        File pathFile = new File(pattern);
        if (pathFile.isAbsolute()) {
            return pathFile;
        }
        File rawFile = new File(baseDir, pattern);
        if (baseDir.getPath().startsWith("\\\\")) {
            return rawFile;
        }
        return new File(rawFile.toURI().normalize().getPath());
    }

    private static File getBaseTruncationDir(File antPatternDir) {
        String dirWithoutPattern = PublishedItemsHelper.getDirWithoutPattern(antPatternDir.getPath());
        if ("".equals(dirWithoutPattern)) {
            return null;
        }
        return new File(dirWithoutPattern);
    }

    private static String getDirWithoutPattern(String pathWithWildCard) {
        String t2 = pathWithWildCard.replace('\\', '/');
        int firstStar = t2.indexOf(42);
        int firstQuestion = t2.indexOf(63);
        int mark = firstStar >= 0 ? (firstStar >= firstQuestion && firstQuestion >= 0 ? firstQuestion : firstStar) : firstQuestion;
        int lastSlash = t2.lastIndexOf(47, mark);
        return lastSlash <= 0 ? "" : pathWithWildCard.substring(0, lastSlash);
    }

    private static boolean isAncestor(File ancestor, File child) throws IOException {
        File parent = child;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = PublishedItemsHelper.getParentFile(parent);
        }
        return false;
    }

    private static File getParentFile(File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    private static String convertAntToRegexp(String antPattern) {
        boolean isTrailingSlash;
        int start;
        StringBuilder builder = new StringBuilder(antPattern.length());
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = !antPattern.startsWith("/") && !antPattern.startsWith("\\") ? 0 : 1; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        return builder.toString();
    }

    private static void collectMatchedFiles(File absoluteRoot, File root, Pattern pattern, List files) {
        File[] dirs = root.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path = UploadSpecHelper.getRelativePath(absoluteRoot, dir).replace("\\", "/");
                if (!pattern.matcher(path).matches()) continue;
                files.add(dir);
                continue;
            }
            PublishedItemsHelper.collectMatchedFiles(absoluteRoot, dir, pattern, files);
        }
    }

    private static void collectMatchedFiles(File absoluteRoot, File root, Pattern pattern, List files, boolean recursive) {
        File[] dirs = root.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path = UploadSpecHelper.getRelativePath(absoluteRoot, dir).replace("\\", "/");
                if (!pattern.matcher(path).matches() && (!recursive || !pattern.matcher(StringUtils.substringAfterLast(path, "/")).matches())) continue;
                files.add(dir);
                continue;
            }
            if (!PublishedItemsHelper.continueDepthSearch(absoluteRoot, dir, pattern, recursive)) continue;
            PublishedItemsHelper.collectMatchedFiles(absoluteRoot, dir, pattern, files, recursive);
        }
    }

    private static boolean continueDepthSearch(File absoluteRoot, File dir, Pattern pattern, boolean recursive) {
        int patternPathDepth;
        if (recursive) {
            return true;
        }
        int relativePathDepth = StringUtils.countMatches((CharSequence)UploadSpecHelper.getRelativePath(absoluteRoot, dir).replace("\\", "/"), "/");
        return relativePathDepth < (patternPathDepth = StringUtils.countMatches((CharSequence)pattern.toString(), "/"));
    }

    public static String calculateTargetPath(String targetPattern, File artifactFile) {
        String relativePath = UploadSpecHelper.calculateTargetRelativePath(artifactFile);
        if (relativePath == null) {
            throw new IllegalArgumentException("Cannot calculate a target path given a null relative path.");
        }
        if (StringUtils.isBlank(targetPattern)) {
            return relativePath;
        }
        relativePath = FilenameUtils.separatorsToUnix(relativePath);
        if (StringUtils.startsWith(targetPattern = FilenameUtils.separatorsToUnix(targetPattern), "/")) {
            return targetPattern + "/" + artifactFile.getName();
        }
        StringBuilder itemPathBuilder = new StringBuilder();
        String[] targetTokens = targetPattern.split("/");
        boolean addedRelativeParent = false;
        for (int i = 0; i < targetTokens.length; ++i) {
            boolean lastToken = i == targetTokens.length - 1;
            String targetToken = targetTokens[i];
            if ("**".equals(targetToken)) {
                if (!lastToken) {
                    String relativeParentPath = FilenameUtils.getPathNoEndSeparator(relativePath);
                    itemPathBuilder.append(relativeParentPath);
                    addedRelativeParent = true;
                } else {
                    itemPathBuilder.append(relativePath);
                }
            } else if (targetToken.startsWith("*.")) {
                String newFileName = FilenameUtils.removeExtension(FilenameUtils.getName(relativePath)) + targetToken.substring(1);
                itemPathBuilder.append(newFileName);
            } else if ("*".equals(targetToken)) {
                itemPathBuilder.append(FilenameUtils.getName(relativePath));
            } else {
                if (StringUtils.isNotBlank(targetToken)) {
                    itemPathBuilder.append(targetToken);
                }
                if (lastToken) {
                    if (itemPathBuilder.length() > 0) {
                        itemPathBuilder.append("/");
                    }
                    if (addedRelativeParent) {
                        itemPathBuilder.append(FilenameUtils.getName(relativePath));
                    } else {
                        itemPathBuilder.append(relativePath);
                    }
                }
            }
            if (lastToken) continue;
            itemPathBuilder.append("/");
        }
        return itemPathBuilder.toString();
    }
}

