/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.utils;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class BambooUtils {
    public static final String JFROG_PLUGIN_NAME = "bamboo-jfrog-plugin";

    public static String getJFrogPluginIdentifier(PluginAccessor pluginAccessor) {
        Plugin plugin = pluginAccessor.getPlugin("org.jfrog.bamboo.bamboo-jfrog-plugin");
        if (plugin != null) {
            return "bamboo-jfrog-plugin/" + plugin.getPluginInformation().getVersion();
        }
        return "";
    }

    public static String getJfrogTmpDir(CustomVariableContext customVariableContext) throws IOException {
        String bambooTemp = ((VariableDefinitionContext)customVariableContext.getVariableContexts().get("tmp.directory")).getValue();
        Path jfrogSpecificBuildTmp = Files.createDirectories(Paths.get(bambooTemp, "jfrog"), new FileAttribute[0]);
        return jfrogSpecificBuildTmp.toString();
    }

    public static String getJfrogTmpSubdir(CustomVariableContext customVariableContext, String subdir) throws IOException {
        String jfrogTemp = BambooUtils.getJfrogTmpDir(customVariableContext);
        Path jfrogSpecificBuildTmp = Files.createDirectories(Paths.get(jfrogTemp, subdir), new FileAttribute[0]);
        return jfrogSpecificBuildTmp.toString();
    }

    public static String createBambooBuildUrl(String fullBuildKey, AdministrationConfiguration administrationConfiguration, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        String url = "";
        if (administrationConfiguration != null) {
            url = administrationConfiguration.getBaseUrl();
        } else if (administrationConfigurationAccessor != null) {
            url = administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
        }
        StringBuilder summaryUrl = new StringBuilder(url);
        if (!url.endsWith("/")) {
            summaryUrl.append("/");
        }
        return summaryUrl.append("browse/").append(EscapeChars.forFormSubmission((String)fullBuildKey)).toString();
    }
}

