/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.config;

import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.config.EncryptionHelper;
import org.jfrog.bamboo.config.ServerConfig;
import org.jfrog.bamboo.config.ServerConfigManager;
import org.jfrog.bamboo.utils.BuildLog;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class JfrogServerConfigAction
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private static final Logger log = LogManager.getLogger(JfrogServerConfigAction.class);
    private static final String MODE_ADD = "add";
    private static final String AUTH_TYPE_TOKEN = "token";
    private static final String AUTH_TYPE_BASIC = "basic";
    private static final String AUTH_TYPE_NO_AUTH = "noAuth";
    private String mode;
    private String authType;
    private boolean specificVersion;
    private boolean fromArtifactory;
    private String serverId;
    private String url;
    private String username;
    private String password;
    private String accessToken;
    private String cliVersion;
    private String cliRepository;
    private final ServerConfigManager serverConfigManager;
    private String testConnection;

    public JfrogServerConfigAction(ServerConfigManager serverConfigManager) {
        this.serverConfigManager = serverConfigManager;
        this.mode = MODE_ADD;
        this.authType = AUTH_TYPE_TOKEN;
        this.specificVersion = false;
        this.fromArtifactory = false;
    }

    public void validate() {
        this.clearErrorsAndMessages();
        if (StringUtils.isBlank((String)this.serverId)) {
            this.addFieldError("serverId", "Please specify a Server ID identifier.");
        } else if (MODE_ADD.equals(this.mode) && this.serverConfigManager.getServerConfigById(this.serverId) != null) {
            this.addFieldError("serverId", "Server ID already exists.");
        }
        if (StringUtils.isBlank((String)this.url)) {
            this.addFieldError("url", "Please specify a URL of a JFrog Platform.");
        } else if (!StringUtils.startsWithIgnoreCase((String)this.url, (String)"https://")) {
            this.addFieldError("url", "URL should start with 'https://'");
        } else {
            try {
                new URL(this.url);
            }
            catch (MalformedURLException mue) {
                this.addFieldError("url", "Please specify a valid URL of a JFrog Platform. " + ExceptionUtils.getRootCauseMessage((Throwable)mue));
            }
        }
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isBlank((String)this.password)) {
            this.addFieldError("password", "Please specify the password of your JFrog Platform.");
        } else if (StringUtils.isBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            this.addFieldError("username", "Please specify the username of your JFrog Platform.");
        }
    }

    public String doAdd() {
        return "input";
    }

    public String doCreate() {
        if (this.isTestConnection()) {
            this.testConnection();
            return "input";
        }
        this.serverConfigManager.addServerConfiguration(this.createServerConfig());
        return "success";
    }

    public String doEdit() throws IllegalArgumentException {
        ServerConfig serverConfig = this.serverConfigManager.getServerConfigById(this.serverId);
        if (serverConfig == null) {
            throw new IllegalArgumentException("Could not find Artifactory server configuration by the ID " + this.serverId);
        }
        this.serverId = serverConfig.getServerId();
        this.url = serverConfig.getUrl();
        this.username = serverConfig.getUsername();
        this.cliVersion = serverConfig.getCliVersion();
        this.cliRepository = serverConfig.getCliRepository();
        this.password = EncryptionHelper.encryptForUi(serverConfig.getPassword());
        this.accessToken = EncryptionHelper.encryptForUi(serverConfig.getAccessToken());
        if (StringUtils.isNotBlank((String)this.accessToken)) {
            this.authType = AUTH_TYPE_TOKEN;
        } else if (StringUtils.isNotBlank((String)this.password)) {
            this.authType = AUTH_TYPE_BASIC;
        }
        if (StringUtils.isNotBlank((String)this.cliVersion)) {
            this.specificVersion = true;
        }
        if (StringUtils.isNotBlank((String)this.cliRepository)) {
            this.fromArtifactory = true;
        }
        return "input";
    }

    public String doUpdate() {
        this.password = EncryptionHelper.decryptIfNeeded(this.password);
        this.accessToken = EncryptionHelper.decryptIfNeeded(this.accessToken);
        if (this.isTestConnection()) {
            this.testConnection();
            this.password = EncryptionHelper.encryptForUi(this.password);
            this.accessToken = EncryptionHelper.encryptForUi(this.accessToken);
            return "input";
        }
        this.serverConfigManager.updateServerConfiguration(this.createServerConfig());
        return "success";
    }

    private void testConnection() {
        ServerConfig serverConfig = this.createServerConfig();
        try (ArtifactoryManager manager = new ArtifactoryManager(serverConfig.getUrl() + "/artifactory", serverConfig.getUsername(), serverConfig.getPassword(), serverConfig.getAccessToken(), new BuildLog());){
            ArtifactoryVersion rtVersion = manager.getVersion();
            if (rtVersion == null || rtVersion.equals(ArtifactoryVersion.NOT_FOUND)) {
                this.addActionError("Couldn't reach JFrog Artifactory server");
            }
            this.addActionMessage("Connection successful! JFrog Artifactory version: " + rtVersion);
        }
        catch (Exception e) {
            this.addActionError("Connection failed: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
            log.error("Error while testing the connection to Artifactory server " + this.url, (Throwable)e);
        }
    }

    @NotNull
    private ServerConfig createServerConfig() {
        return new ServerConfig(this.serverId, StringUtils.removeEnd((String)this.url, (String)"/"), this.authType.equals(AUTH_TYPE_BASIC) ? this.username : "", this.authType.equals(AUTH_TYPE_BASIC) ? this.password : "", this.authType.equals(AUTH_TYPE_TOKEN) ? this.accessToken : "", this.specificVersion ? StringUtils.removeStart((String)this.cliVersion, (String)"v") : "", this.fromArtifactory ? this.cliRepository : "");
    }

    public String doDelete() {
        this.serverConfigManager.deleteServerConfiguration(this.serverId);
        return "success";
    }

    public String doBrowse() throws Exception {
        return super.execute();
    }

    public String browse() throws Exception {
        return super.execute();
    }

    public String confirm() {
        return "success";
    }

    private boolean isTestConnection() {
        return StringUtils.isNotBlank((String)this.testConnection);
    }

    public String getMode() {
        return this.mode;
    }

    public String getAuthType() {
        return this.authType;
    }

    public boolean isSpecificVersion() {
        return this.specificVersion;
    }

    public boolean isFromArtifactory() {
        return this.fromArtifactory;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getCliVersion() {
        return this.cliVersion;
    }

    public String getCliRepository() {
        return this.cliRepository;
    }

    public ServerConfigManager getServerConfigManager() {
        return this.serverConfigManager;
    }

    public String getTestConnection() {
        return this.testConnection;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setSpecificVersion(boolean specificVersion) {
        this.specificVersion = specificVersion;
    }

    public void setFromArtifactory(boolean fromArtifactory) {
        this.fromArtifactory = fromArtifactory;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setCliVersion(String cliVersion) {
        this.cliVersion = cliVersion;
    }

    public void setCliRepository(String cliRepository) {
        this.cliRepository = cliRepository;
    }

    public void setTestConnection(String testConnection) {
        this.testConnection = testConnection;
    }
}

