/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.JfContext;
import org.jfrog.bamboo.JfInstaller;
import org.jfrog.bamboo.config.ServerConfig;
import org.jfrog.bamboo.config.ServerConfigManager;
import org.jfrog.bamboo.utils.BambooUtils;
import org.jfrog.bamboo.utils.BuildLog;
import org.jfrog.bamboo.utils.ExecutableRunner;
import org.jfrog.bamboo.utils.Utils;

public class JfTask
extends JfContext
implements TaskType {
    private BuildLog buildLog;
    private ServerConfigManager serverConfigManager;
    private ExecutableRunner commandRunner;
    private CustomVariableContext customVariableContext;
    private PluginAccessor pluginAccessor;
    private AdministrationConfiguration administrationConfiguration;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) {
        this.buildLog = new BuildLog(taskContext.getBuildLogger());
        this.serverConfigManager = ServerConfigManager.getInstance();
        ConfigurationMap confMap = taskContext.getConfigurationMap();
        TaskResultBuilder resultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        ServerConfig selectedServerConfig = this.serverConfigManager.getServerConfigById((String)confMap.get((Object)"jf.task.server.id"));
        if (selectedServerConfig == null) {
            this.buildLog.error("The selected Server ID doesn't exists: " + (String)confMap.get((Object)"jf.task.server.id"));
            return resultBuilder.failedWithError().build();
        }
        try {
            String jfrogTmpDir = BambooUtils.getJfrogTmpDir(this.customVariableContext);
            String jfExecutablePath = JfInstaller.getJfExecutable(selectedServerConfig, jfrogTmpDir, this.buildLog);
            Map<String, String> envs = this.createJfrogEnvironmentVariables(taskContext.getBuildContext(), selectedServerConfig);
            File workingDir = this.getWorkingDirectory((String)confMap.get((Object)"jf.task.working.directory"), taskContext.getWorkingDirectory());
            this.buildLog.info("Working directory: " + workingDir);
            List<String> secrets = List.of(selectedServerConfig.getPassword(), selectedServerConfig.getAccessToken());
            this.commandRunner = new ExecutableRunner(jfExecutablePath, workingDir, envs, secrets, this.buildLog);
            int exitCode = this.configAllJFrogServers();
            if (exitCode != 0) {
                return resultBuilder.failedWithError().build();
            }
            exitCode = this.commandRunner.run(List.of("config", "use", selectedServerConfig.getServerId()));
            if (exitCode != 0) {
                return resultBuilder.failedWithError().build();
            }
            String cliCommand = (String)confMap.get((Object)"jf.task.command");
            List<String> unwrappedArgs = Utils.splitStringPreservingQuotes(cliCommand = StringUtils.removeStart((String)cliCommand, (String)"jf ")).stream().map(Utils::unQuote).collect(Collectors.toList());
            exitCode = this.commandRunner.run(unwrappedArgs);
            if (exitCode != 0) {
                return resultBuilder.failedWithError().build();
            }
        }
        catch (Exception e) {
            this.buildLog.error(ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            return resultBuilder.failedWithError().build();
        }
        return resultBuilder.success().build();
    }

    public File getWorkingDirectory(String customWd, File defaultWd) throws IOException {
        if (StringUtils.isBlank((String)customWd)) {
            return defaultWd;
        }
        if (!Files.exists(Paths.get(customWd, new String[0]), new LinkOption[0])) {
            throw new IOException("Working directory: '" + customWd + "' does not exist.");
        }
        return new File(customWd);
    }

    public Map<String, String> createJfrogEnvironmentVariables(BuildContext buildContext, ServerConfig serverConfig) throws IOException {
        HashMap<String, String> jfEnvs = new HashMap<String, String>(){

            @Override
            public String put(String key, String value) {
                if (StringUtils.isBlank((String)System.getProperty(key))) {
                    return super.put(key, value);
                }
                return "";
            }
        };
        jfEnvs.put("JFROG_CLI_SERVER_ID", serverConfig.getServerId());
        jfEnvs.put("JFROG_CLI_BUILD_NAME", buildContext.getPlanName());
        jfEnvs.put("JFROG_CLI_BUILD_NUMBER", String.valueOf(buildContext.getBuildNumber()));
        String fullBuildKey = buildContext.getResultKey().getKey();
        jfEnvs.put("JFROG_CLI_HOME_DIR", BambooUtils.getJfrogTmpSubdir(this.customVariableContext, fullBuildKey));
        jfEnvs.put("JFROG_CLI_DEPENDENCIES_DIR", BambooUtils.getJfrogTmpSubdir(this.customVariableContext, "dependencies"));
        if (StringUtils.isNotBlank((String)serverConfig.getCliRepository())) {
            jfEnvs.put("JFROG_CLI_RELEASES_REPO", serverConfig.getServerId() + "/" + serverConfig.getCliRepository());
        }
        String buildUrl = BambooUtils.createBambooBuildUrl(fullBuildKey, this.administrationConfiguration, this.administrationConfigurationAccessor);
        jfEnvs.put("JFROG_CLI_BUILD_URL", buildUrl);
        jfEnvs.put("JFROG_CLI_USER_AGENT", BambooUtils.getJFrogPluginIdentifier(this.pluginAccessor));
        jfEnvs.put("JFROG_CLI_LOG_TIMESTAMP", "OFF");
        this.buildLog.info("The following JFrog CLI environment variables will be used: " + jfEnvs);
        return jfEnvs;
    }

    private int configAllJFrogServers() throws IOException, InterruptedException {
        ServerConfig serverConfig;
        int exitCode = 0;
        Iterator<ServerConfig> iterator = this.serverConfigManager.getAllServerConfigs().iterator();
        while (iterator.hasNext() && (exitCode = this.runJFrogCliConfigAddCommand(serverConfig = iterator.next())) == 0) {
        }
        return exitCode;
    }

    public int runJFrogCliConfigAddCommand(ServerConfig serverConfig) throws IOException, InterruptedException {
        ArrayList<String> configAddArgs = new ArrayList<String>(List.of("config", "add", serverConfig.getServerId(), "--url=" + serverConfig.getUrl(), "--interactive=false", "--overwrite=true"));
        if (StringUtils.isNotBlank((String)serverConfig.getAccessToken())) {
            configAddArgs.add("--access-token=" + serverConfig.getAccessToken());
        } else if (StringUtils.isNotBlank((String)serverConfig.getUsername()) && StringUtils.isNotBlank((String)serverConfig.getPassword())) {
            configAddArgs.add("--user=" + serverConfig.getUsername());
            configAddArgs.add("--password=" + serverConfig.getPassword());
        }
        return this.commandRunner.run(configAddArgs);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        this.administrationConfiguration = administrationConfiguration;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }
}

