/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.config.ServerConfig;
import org.jfrog.bamboo.utils.BuildLog;
import org.jfrog.bamboo.utils.OsUtils;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class JfInstaller {
    private static final String RELEASE = "[RELEASE]";
    private static final String DEFAULT_CLI_VERSION = "2.44.0";
    public static final String RELEASES_URL = "https://releases.jfrog.io";
    public static final String BINARY_NAME = "jf";
    private static final String SHA256_FILE_NAME = "sha256";
    public static final String JFROG_CLI_DIRECTORY = "jfrog-cli";

    private static String getJfrogCliBinaryName() {
        if (OsUtils.isWindows()) {
            return "jf.exe";
        }
        return BINARY_NAME;
    }

    private static Path getJfrogExecutableDirectory(String jfrogTmpDir, String version) throws IOException {
        Path jfExecDir = version.equals(RELEASE) ? Paths.get(jfrogTmpDir, JFROG_CLI_DIRECTORY) : Paths.get(jfrogTmpDir, JFROG_CLI_DIRECTORY, version);
        return Files.createDirectories(jfExecDir, new FileAttribute[0]).toAbsolutePath();
    }

    public static String getJfExecutable(ServerConfig serverConfig, String jfrogTmpDir, BuildLog buildLog) throws IOException {
        String string;
        buildLog.info("Getting JFrog CLI executable...");
        boolean downloadFromReleases = StringUtils.isBlank((String)serverConfig.getCliRepository());
        String version = StringUtils.defaultIfBlank((String)serverConfig.getCliVersion(), (String)(downloadFromReleases ? RELEASE : DEFAULT_CLI_VERSION));
        Path executableLocation = JfInstaller.getJfrogExecutableDirectory(jfrogTmpDir, version);
        String binaryName = JfInstaller.getJfrogCliBinaryName();
        String executableFullPath = Paths.get(executableLocation.toString(), binaryName).toString();
        String downloadSourceUrl = downloadFromReleases ? RELEASES_URL : serverConfig.getUrl();
        ArtifactoryManager manager = new ArtifactoryManager(downloadSourceUrl + "/artifactory", downloadFromReleases ? "" : serverConfig.getUsername(), downloadFromReleases ? "" : serverConfig.getPassword(), downloadFromReleases ? "" : serverConfig.getAccessToken(), buildLog);
        try {
            String artifactorySha256;
            String cliUrlSuffix = String.format("/jfrog-cli/v2-jf/%s/jfrog-cli-%s/%s", version, OsUtils.getOsDetails(), binaryName);
            if (!downloadFromReleases) {
                cliUrlSuffix = String.format("/%s/artifactory%s", serverConfig.getCliRepository(), cliUrlSuffix);
            }
            if (JfInstaller.shouldDownloadTool(executableLocation, artifactorySha256 = manager.downloadHeader(cliUrlSuffix, "X-Checksum-Sha256"))) {
                if (version.equals(RELEASE)) {
                    buildLog.info(String.format("Download '%s' latest version from: %s%n", binaryName, manager.getUrl() + cliUrlSuffix));
                } else {
                    buildLog.info(String.format("Download '%s' version %s from: %s%n", binaryName, version, manager.getUrl() + cliUrlSuffix));
                }
                File downloadResponse = manager.downloadToFile(cliUrlSuffix, executableFullPath);
                if (!downloadResponse.setExecutable(true)) {
                    throw new IOException("No permission to add execution permission to binary");
                }
                buildLog.info("Successfully downloaded JFrog CLI executable: " + downloadResponse.getPath());
                JfInstaller.createSha256File(executableLocation, artifactorySha256);
            } else {
                buildLog.info("Found existing JFrog CLI executable");
            }
            string = executableFullPath;
        }
        catch (Throwable throwable) {
            try {
                try {
                    manager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Failed while running download CLI command with error: " + e);
            }
        }
        manager.close();
        return string;
    }

    private static boolean shouldDownloadTool(Path toolLocation, String artifactorySha256) throws IOException {
        if (artifactorySha256.isEmpty()) {
            return true;
        }
        Path path = toolLocation.resolve(SHA256_FILE_NAME);
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        String fileContent = Files.readString(path);
        return !StringUtils.equals((String)fileContent, (String)artifactorySha256);
    }

    private static void createSha256File(Path toolLocation, String artifactorySha256) throws IOException {
        File file = new File(toolLocation.toFile(), SHA256_FILE_NAME);
        Files.write(file.toPath(), artifactorySha256.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

