/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs.distribution;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.filespecs.distribution.PathMapping;
import org.jfrog.filespecs.entities.FilesGroup;

public class PathMappingGenerator {
    public static PathMapping createPathMapping(FilesGroup filesGroup) {
        if (StringUtils.isEmpty(filesGroup.getTarget())) {
            return null;
        }
        String input = PathMappingGenerator.convertWildcardStringToRegexp(filesGroup.getPattern());
        String output = PathMappingGenerator.convertPlaceholdersToApiFormat(filesGroup.getTarget());
        PathMapping mapping = new PathMapping(input, output);
        return mapping;
    }

    private static String convertWildcardStringToRegexp(String wildcardStr) {
        if (wildcardStr == null) {
            return "^$";
        }
        String wildcard = ".*";
        StringBuilder sb = new StringBuilder(wildcardStr.length());
        int length = wildcardStr.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = wildcardStr.charAt(i);
            switch (c) {
                case '*': {
                    sb.append(wildcard);
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                case '$': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append("\\");
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String regexStr = sb.toString();
        if (regexStr.endsWith("/")) {
            regexStr = regexStr + wildcard;
        }
        return "^" + regexStr + "$";
    }

    private static String convertPlaceholdersToApiFormat(String str) {
        Matcher matcher = Pattern.compile("(\\{\\d\\})").matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "\\$" + matcher.group().charAt(1));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

