/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.scan.Cve;
import org.jfrog.build.extractor.scan.Severity;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Issue
implements Comparable<Issue> {
    private Severity severity = Severity.Normal;
    private List<String> fixedVersions;
    private List<String> references;
    private String component = "";
    private String ignoreRuleUrl;
    private List<Cve> cves;
    private String summary;
    private String issueId;

    public Issue() {
    }

    public Issue(String issueId, Severity severity, String summary, List<String> fixedVersions, List<Cve> cves, List<String> references, String ignoreRuleUrl) {
        this.issueId = issueId;
        this.severity = severity;
        this.summary = summary;
        this.fixedVersions = fixedVersions;
        this.cves = cves;
        this.references = references;
        this.ignoreRuleUrl = ignoreRuleUrl;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<String> getFixedVersions() {
        return this.fixedVersions;
    }

    public void setFixedVersions(List<String> fixedVersions) {
        this.fixedVersions = fixedVersions;
    }

    public List<Cve> getCves() {
        return this.cves;
    }

    public List<String> getReferences() {
        return this.references;
    }

    public String getIgnoreRuleUrl() {
        return this.ignoreRuleUrl;
    }

    @JsonIgnore
    public boolean isTopSeverity() {
        return this.getSeverity() == Severity.Critical;
    }

    @JsonIgnore
    public boolean isHigherSeverityThan(Issue o) {
        return this.getSeverity().isHigherThan(o.getSeverity());
    }

    @Override
    public int compareTo(Issue otherIssue) {
        return Integer.compare(this.hashCode(), Objects.hashCode(otherIssue));
    }

    public boolean equals(Object other) {
        if (!(other instanceof Issue)) {
            return false;
        }
        return StringUtils.equals(((Issue)other).getIssueId(), this.getIssueId());
    }

    public int hashCode() {
        return Objects.hash(this.issueId);
    }
}

