/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.ci;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BaseBuildBean;
import org.jfrog.build.extractor.ci.Dependency;

public class Module
extends BaseBuildBean {
    private String type;
    private String id;
    private String repository;
    private String md5;
    private String sha1;
    private List<Artifact> artifacts;
    private List<Artifact> excludedArtifacts;
    private List<Dependency> dependencies;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getMd5() {
        return this.md5;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public List<Artifact> getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setExcludedArtifacts(List<Artifact> excludedArtifacts) {
        this.excludedArtifacts = excludedArtifacts;
    }

    public void append(Module other) {
        this.artifacts = this.appendBuildFileLists(this.artifacts, other.getArtifacts());
        this.excludedArtifacts = this.appendBuildFileLists(this.excludedArtifacts, other.getExcludedArtifacts());
        this.dependencies = this.appendBuildFileLists(this.dependencies, other.getDependencies());
        this.type = StringUtils.defaultIfEmpty(this.type, other.type);
        this.repository = StringUtils.defaultIfEmpty(this.repository, other.repository);
        this.md5 = StringUtils.defaultIfEmpty(this.md5, other.md5);
        this.sha1 = StringUtils.defaultIfEmpty(this.sha1, other.sha1);
    }

    private <T extends BaseBuildBean> List<T> appendBuildFileLists(List<T> a, List<T> b) {
        if (a == null && b == null) {
            return null;
        }
        return Stream.of(Optional.ofNullable(a).orElseGet(Collections::emptyList), Optional.ofNullable(b).orElseGet(Collections::emptyList)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        return StringUtils.equals(this.getType(), module.getType()) && StringUtils.equals(this.getId(), module.getId()) && StringUtils.equals(this.getRepository(), module.getRepository()) && StringUtils.equals(this.getSha1(), module.getSha1()) && StringUtils.equals(this.getMd5(), module.getMd5()) && ArrayUtils.isEquals(this.getArtifacts(), module.getArtifacts()) && ArrayUtils.isEquals(this.getExcludedArtifacts(), module.getExcludedArtifacts()) && ArrayUtils.isEquals(this.getDependencies(), module.getDependencies());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getId(), this.getRepository(), this.getSha1(), this.getMd5(), this.getArtifacts(), this.getExcludedArtifacts(), this.getDependencies());
    }
}

