/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Utils {
    public static ObjectMapper createMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static String unQuote(String str) {
        if (str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static List<String> splitStringPreservingQuotes(String input) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        boolean insideDoubleQuotes = false;
        boolean insideSingleQuotes = false;
        for (char c : input.toCharArray()) {
            if (StringUtils.isWhitespace((String)String.valueOf(c)) && !insideDoubleQuotes && !insideSingleQuotes) {
                if (token.length() <= 0) continue;
                tokens.add(token.toString());
                token.setLength(0);
                continue;
            }
            if (c == '\"') {
                insideDoubleQuotes = !insideDoubleQuotes;
            } else if (c == '\'') {
                insideSingleQuotes = !insideSingleQuotes;
            }
            token.append(c);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }
}

