/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.config;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfrog.bamboo.config.EncryptionHelper;
import org.jfrog.bamboo.config.ServerConfig;
import org.jfrog.bamboo.config.ServerConfigManager;
import org.jfrog.bamboo.utils.Utils;
import org.springframework.stereotype.Component;

@Component
public class ServerConfigManagerImpl
implements ServerConfigManager {
    private final transient Logger log = LogManager.getLogger(ServerConfigManagerImpl.class);
    private static final String JFROG_CONFIG_KEY = "org.jfrog.bamboo.configurations.v1";
    private final List<ServerConfig> configuredServers = new CopyOnWriteArrayList<ServerConfig>();
    @ComponentImport
    private BandanaManager bandanaManager = null;
    private final ObjectMapper mapper = Utils.createMapper();

    @Inject
    public ServerConfigManagerImpl(BandanaManager bandanaManager) {
        this.setBandanaManager(bandanaManager);
    }

    @Override
    public List<ServerConfig> getAllServerConfigs() {
        return new ArrayList<ServerConfig>(this.configuredServers);
    }

    @Override
    public ServerConfig getServerConfigById(String serverId) {
        for (ServerConfig configuredServer : this.configuredServers) {
            if (!Objects.equals(configuredServer.getServerId(), serverId)) continue;
            return configuredServer;
        }
        return null;
    }

    @Override
    public void addServerConfiguration(ServerConfig serverConfig) {
        this.configuredServers.add(serverConfig);
        try {
            this.persist();
        }
        catch (JsonProcessingException | UnsupportedEncodingException | IllegalAccessException e) {
            this.log.error("Could not add JFrog configuration: Configuration persistence failed");
        }
    }

    @Override
    public void deleteServerConfiguration(String serverId) {
        for (ServerConfig configuredServer : this.configuredServers) {
            if (!Objects.equals(configuredServer.getServerId(), serverId)) continue;
            this.configuredServers.remove(configuredServer);
            try {
                this.persist();
            }
            catch (JsonProcessingException | UnsupportedEncodingException | IllegalAccessException e) {
                this.log.error("Could not delete JFrog configuration.", e);
            }
            break;
        }
    }

    @Override
    public void updateServerConfiguration(ServerConfig updated) {
        for (ServerConfig configuredServer : this.configuredServers) {
            if (!Objects.equals(configuredServer.getServerId(), updated.getServerId())) continue;
            configuredServer.copy(updated);
            try {
                this.persist();
            }
            catch (JsonProcessingException | UnsupportedEncodingException | IllegalAccessException e) {
                this.log.error("Could not update JFrog configuration.", e);
            }
            break;
        }
    }

    private void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        try {
            String existingServersListAction = (String)bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, JFROG_CONFIG_KEY);
            if (StringUtils.isNotBlank((String)existingServersListAction)) {
                List serverConfigList = (List)this.mapper.readValue(existingServersListAction, (TypeReference)new TypeReference<List<ServerConfig>>(){});
                for (ServerConfig serverConfig : serverConfigList) {
                    ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                    String json = ow.writeValueAsString((Object)serverConfig);
                    ServerConfig tempServerConfig = (ServerConfig)new ObjectMapper().readValue(json, ServerConfig.class);
                    ServerConfig decryptedConfig = new ServerConfig();
                    decryptedConfig.copy(serverConfig);
                    decryptedConfig.setPassword(EncryptionHelper.decrypt(tempServerConfig.getPassword()));
                    decryptedConfig.setAccessToken(EncryptionHelper.decrypt(tempServerConfig.getAccessToken()));
                    this.configuredServers.add(decryptedConfig);
                }
            }
        }
        catch (IOException e) {
            this.log.error("Could not load JFrog configuration: Configuration file access failed");
        }
    }

    @Override
    public synchronized void persist() throws IllegalAccessException, UnsupportedEncodingException, JsonProcessingException {
        ArrayList<ServerConfig> serverConfigs = new ArrayList<ServerConfig>();
        for (ServerConfig serverConfig : this.configuredServers) {
            ServerConfig encryptedConfig = new ServerConfig();
            encryptedConfig.copy(serverConfig);
            encryptedConfig.setPassword(EncryptionHelper.encryptForConfig(serverConfig.getPassword()));
            encryptedConfig.setAccessToken(EncryptionHelper.encryptForConfig(serverConfig.getAccessToken()));
            serverConfigs.add(encryptedConfig);
        }
        String serverConfigsString = this.mapper.writeValueAsString(serverConfigs);
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, JFROG_CONFIG_KEY, (Object)serverConfigsString);
    }
}

