/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.config.ServerConfigManager;

public class JfContext
extends AbstractTaskConfigurator {
    public static final String JF_TASK_SERVER_ID = "jf.task.server.id";
    public static final String JF_TASK_COMMAND = "jf.task.command";
    public static final String JF_TASK_WORKING_DIRECTORY = "jf.task.working.directory";
    @Inject
    private ServerConfigManager serverConfigManager;

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(JF_TASK_COMMAND, "jf ");
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", 1);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map config = taskDefinition.getConfiguration();
        context.put(JF_TASK_SERVER_ID, config.get(JF_TASK_SERVER_ID));
        context.put(JF_TASK_COMMAND, config.get(JF_TASK_COMMAND));
        context.put(JF_TASK_WORKING_DIRECTORY, config.get(JF_TASK_WORKING_DIRECTORY));
        context.put("serverConfigManager", this.serverConfigManager);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put(JF_TASK_SERVER_ID, params.getString(JF_TASK_SERVER_ID));
        config.put(JF_TASK_COMMAND, params.getString(JF_TASK_COMMAND));
        config.put(JF_TASK_WORKING_DIRECTORY, params.getString(JF_TASK_WORKING_DIRECTORY));
        return config;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        String cliCommand = params.getString(JF_TASK_COMMAND);
        if (!StringUtils.startsWith((String)StringUtils.trim((String)cliCommand), (String)"jf ")) {
            errorCollection.addErrorMessage("JFrog CLI command should start with 'jf '.");
        }
        if (StringUtils.isBlank((String)params.getString(JF_TASK_SERVER_ID))) {
            errorCollection.addErrorMessage("JFrog configuration should be selected");
        }
    }
}

