/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.multiMap.ListMultimap;
import org.jfrog.build.api.multiMap.Multimap;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.UrlUtils;
import org.jfrog.build.extractor.clientConfiguration.client.VoidJFrogService;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;

public class SetProperties
extends VoidJFrogService {
    public static final String SET_PROPERTIES_ENDPOINT = "api/storage/";
    private final Multimap<String, String> propertiesMap;
    private final boolean encodeProperties;
    private final String relativePath;
    private final String propertiesString;

    private SetProperties(String relativePath, String propertiesString, Multimap<String, String> propertiesMap, boolean encodeProperties, Log log) {
        super(log);
        this.relativePath = relativePath;
        this.propertiesMap = propertiesMap;
        this.propertiesString = propertiesString;
        this.encodeProperties = encodeProperties;
    }

    public SetProperties(String relativePath, String propertiesString, boolean encodeProperties, Log log) {
        this(relativePath, propertiesString, null, encodeProperties, log);
    }

    public SetProperties(String relativePath, Multimap<String, String> propertiesMap, boolean encodeProperties, Log log) {
        this(relativePath, null, propertiesMap, encodeProperties, log);
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        String requestUrl = SET_PROPERTIES_ENDPOINT + UrlUtils.encodeUrl(StringUtils.stripEnd(this.relativePath, "/")) + "?properties=";
        requestUrl = StringUtils.isNotEmpty(this.propertiesString) ? requestUrl + (this.encodeProperties ? DeploymentUrlUtils.buildMatrixParamsString(this.mapPropsString(this.propertiesString), true) : this.propertiesString) : requestUrl + DeploymentUrlUtils.buildMatrixParamsString(this.propertiesMap, this.encodeProperties);
        return new HttpPut(requestUrl);
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Failed to set properties to '" + this.relativePath + "'");
        SetProperties.throwException(entity, this.getStatusCode());
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
        if (StringUtils.isEmpty(this.propertiesString)) {
            return;
        }
        for (String prop : this.propertiesString.trim().split(";")) {
            if (prop.isEmpty()) continue;
            String key = StringUtils.substringBefore(prop, "=");
            if (key.isEmpty()) {
                throw new IOException("Setting properties: Every property must have a key.");
            }
            String values = StringUtils.substringAfter(prop, "=");
            if (!values.isEmpty() && StringUtils.countMatches((CharSequence)values, ",") != values.length()) continue;
            throw new IOException("Setting properties: Every property must have at least one value.");
        }
    }

    private Multimap<String, String> mapPropsString(String props) {
        String[] propsList;
        ListMultimap<String, String> propsMap = new ListMultimap<String, String>();
        for (String prop : propsList = props.split(";")) {
            if (!StringUtils.isNotEmpty(prop)) continue;
            String[] propParts = prop.split("=");
            ((Multimap)propsMap).put(propParts[0], propParts[1]);
        }
        return propsMap;
    }
}

