/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.UrlUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.client.VoidJFrogService;
import org.jfrog.build.extractor.clientConfiguration.util.JsonUtils;

public class PublishBuildInfo
extends VoidJFrogService {
    private static final String BUILD_REST_URL = "/api/build";
    private final Build build;
    private final String platformUrl;
    private String buildJson;

    public PublishBuildInfo(BuildInfo buildInfo, String platformUrl, Log logger) {
        super(logger);
        this.build = buildInfo.ToBuild();
        this.platformUrl = platformUrl;
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Could not build the build-info object.");
        PublishBuildInfo.throwException(entity, this.getStatusCode());
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
        if (this.build == null) {
            return;
        }
        this.buildJson = JsonUtils.toJsonString(this.build);
    }

    @Override
    public HttpRequestBase createRequest() {
        HttpPut request = new HttpPut(BUILD_REST_URL + UrlUtils.getProjectQueryParam(this.build.getProject()));
        StringEntity stringEntity = new StringEntity(this.buildJson, "UTF-8");
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory+json");
        request.setEntity(stringEntity);
        this.log.info("Deploying build info...");
        return request;
    }

    @Override
    public Void execute(JFrogHttpClient client) throws IOException {
        super.execute(client);
        boolean isPlatformUrl = StringUtils.isNotBlank(this.platformUrl);
        String url = isPlatformUrl ? this.platformUrl : client.getUrl();
        String buildInfoUrl = BuildInfoExtractorUtils.createBuildInfoUrl(url, this.build.getName(), this.build.getNumber(), String.valueOf(this.build.getStartedMillis()), this.build.getProject(), true, isPlatformUrl);
        if (StringUtils.isNotBlank(buildInfoUrl)) {
            this.log.info("Build-info successfully deployed. Browse it in Artifactory under " + buildInfoUrl);
        } else {
            this.log.debug("Couldn't create the build-info URL from Artifactory URL: " + client.getUrl());
            this.log.info("Build-info successfully deployed.");
        }
        return (Void)this.result;
    }
}

