/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.buildScanTable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.artifactoryXrayResponse.Issue;
import org.jfrog.build.extractor.scan.Severity;

abstract class ScanTableBase {
    private final Log log;
    protected int longestDisplayName = 0;
    protected final Map<Severity, Set<TableElementBase>> table = new HashMap<Severity, Set<TableElementBase>>();

    protected ScanTableBase(Log log) {
        this.log = log;
    }

    protected abstract String getHeadline();

    protected abstract String[] getHeaders();

    protected abstract String getTableFormat();

    protected abstract String getEmptyTableLine();

    protected String getFormatBase(int longestDisplayName) {
        return "%-6s%-14s%-" + (longestDisplayName + 3) + "s";
    }

    private void printFormattedLine(Object ... args) {
        this.log.info(String.format(this.getTableFormat(), args));
    }

    protected void addElement(Map<Severity, Set<TableElementBase>> table, Issue issue, TableElementBase element) {
        Severity severity = Severity.fromString(issue.getSeverity());
        Set<TableElementBase> elements = table.get((Object)severity);
        if (elements == null) {
            elements = new HashSet<TableElementBase>();
        }
        elements.add(element);
        table.put(severity, elements);
    }

    protected void printTable(Map<Severity, Set<TableElementBase>> table) {
        int line = 1;
        Severity[] severities = Severity.values();
        this.log.info(this.getHeadline());
        if (table.isEmpty()) {
            this.log.info(this.getEmptyTableLine());
            this.log.info("");
            return;
        }
        this.printFormattedLine(this.getHeaders());
        for (int i = severities.length - 1; i >= 0; --i) {
            Severity severity = severities[i];
            Set<TableElementBase> elements = table.get((Object)severity);
            if (elements == null) continue;
            for (TableElementBase element : elements) {
                this.printFormattedLine(element.getLineArgs(line, severity.getSeverityName()));
                ++line;
            }
        }
        this.log.info("");
    }

    protected static abstract class TableElementBase {
        protected final String fileDisplayName;
        protected final String fileSha256;
        protected final String issueSummary;
        protected final String issueDescription;

        protected TableElementBase(String fileDisplayName, String fileSha256, String issueSummary, String issueDescription) {
            this.fileDisplayName = fileDisplayName;
            this.fileSha256 = fileSha256;
            this.issueSummary = issueSummary;
            this.issueDescription = issueDescription;
        }

        protected String getFileDisplayName() {
            return this.fileDisplayName == null ? "" : this.fileDisplayName;
        }

        protected abstract Object[] getLineArgs(int var1, String var2);
    }
}

