/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.utils.BuildLog;
import org.jfrog.build.extractor.UrlUtils;

public class ExecutableRunner {
    private final File workingDir;
    private final String executable;
    private final Map<String, String> envs;
    private final BuildLog buildLog;
    private final List<String> secrets;
    private static final int COMMAND_TIMEOUT = 60;

    public ExecutableRunner(String executable, File workingDir, Map<String, String> envs, List<String> secrets, BuildLog buildLog) {
        this.executable = executable;
        this.workingDir = workingDir;
        this.envs = envs;
        this.buildLog = buildLog;
        this.secrets = secrets;
    }

    public int run(List<String> commandArgs) throws IOException, InterruptedException {
        ArrayList<String> fullCommand = new ArrayList<String>(commandArgs);
        fullCommand.add(0, this.executable);
        ProcessBuilder processBuilder = new ProcessBuilder(fullCommand).directory(this.workingDir).redirectErrorStream(true);
        processBuilder.environment().putAll(this.envs);
        this.buildLog.info("Working Directory: " + String.valueOf(this.workingDir));
        this.buildLog.info("Running command: " + this.maskSecrets(String.join((CharSequence)" ", processBuilder.command())));
        Process process = processBuilder.start();
        Thread outputReader = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.buildLog.info(this.maskSecrets(line));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        outputReader.start();
        if (process.waitFor(60L, TimeUnit.MINUTES)) {
            outputReader.join();
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                this.buildLog.error("Command failed with exit code: " + exitCode);
            }
            return exitCode;
        }
        process.destroy();
        outputReader.interrupt();
        this.buildLog.error("Command timed out after 60 minutes");
        return -1;
    }

    private String maskSecrets(String line) {
        if (this.secrets != null && !this.secrets.isEmpty()) {
            for (String secret : this.secrets) {
                if (!StringUtils.isNotBlank((String)secret)) continue;
                line = line.replaceAll(secret, "***");
            }
        }
        String regex = "--(password|access-token)=\\S+";
        line = line.replaceAll(regex, "--$1=***");
        return UrlUtils.removeCredentialsFromUrl(line);
    }
}

