/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.utils;

import com.atlassian.bamboo.build.logger.BuildLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfrog.build.api.util.Log;

public class BuildLog
implements Log {
    private static final String JFROG_PREFIX = "JFrog Plugin";
    private final Logger log = LogManager.getLogger((String)"JFrog Plugin");
    private final BuildLogger buildLogger;

    public BuildLog() {
        this.buildLogger = null;
    }

    public BuildLog(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
    }

    private String addPrefix(String message) {
        return String.format("[%s] %s", JFROG_PREFIX, message);
    }

    @Override
    public void debug(String message) {
        this.log.debug(message);
    }

    @Override
    public void info(String message) {
        if (this.buildLogger != null) {
            this.buildLogger.addBuildLogEntry(this.addPrefix(message));
        }
        this.log.info(message);
    }

    @Override
    public void warn(String message) {
        if (this.buildLogger != null) {
            this.buildLogger.addBuildLogEntry(this.addPrefix(message));
        }
        this.log.warn(message);
    }

    @Override
    public void error(String message) {
        String prefixedMessage = this.addPrefix(message);
        if (this.buildLogger != null) {
            this.buildLogger.addErrorLogEntry(this.addPrefix(message));
        }
        this.log.error(prefixedMessage);
    }

    @Override
    public void error(String message, Throwable throwable) {
        String prefixedMessage = this.addPrefix(message);
        if (this.buildLogger != null) {
            this.buildLogger.addErrorLogEntry(this.addPrefix(message), throwable);
        }
        this.log.error(prefixedMessage, throwable);
    }
}

