/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.config;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Base32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class EncryptionHelper {
    private static final Logger log = LogManager.getLogger(EncryptionHelper.class);
    private static final String AES_ENCRYPTION_SCHEME = "AES";
    private static final int KEY_LENGTH = 128;
    private static final String uiKey = EncryptionHelper.generateRandomKey();
    private static final String dbKey = "Im54vK3LcFh3r8DCVqWUMw==";
    private static final ThreadLocal<Cipher> threadLocalEncrypter = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance(AES_ENCRYPTION_SCHEME);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            log.error("Cannot create encrypter", (Throwable)e);
            return null;
        }
    });
    private static final ThreadLocal<Cipher> threadLocalDecrypter = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance(AES_ENCRYPTION_SCHEME);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            log.error("Cannot create decrypter", (Throwable)e);
            return null;
        }
    });

    @NotNull
    public static String decrypt(@Nullable String data) {
        if (StringUtils.isEmpty((String)data)) {
            return "";
        }
        try {
            byte[] encrypted = Base64.getMimeDecoder().decode(data);
            return EncryptionHelper.decryptWithKey(dbKey, encrypted);
        }
        catch (Exception e) {
            try {
                byte[] encrypted = Base32.decode((String)data);
                return EncryptionHelper.decryptWithKey(uiKey, encrypted);
            }
            catch (Exception ee) {
                throw new RuntimeException("Failed to decrypt.", ee);
            }
        }
    }

    public static String decryptIfNeeded(String s) {
        try {
            s = EncryptionHelper.decrypt(s);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return s;
    }

    @NotNull
    public static String encryptForConfig(@Nullable String stringToEncrypt) {
        if (StringUtils.isEmpty((String)stringToEncrypt)) {
            return "";
        }
        try {
            byte[] encrypted = EncryptionHelper.getEncrypter(dbKey).doFinal(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
            return Base64.getMimeEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt.", e);
        }
    }

    @NotNull
    public static String encryptForUi(@Nullable String stringToEncrypt) {
        if (StringUtils.isEmpty((String)stringToEncrypt)) {
            return "";
        }
        try {
            byte[] encrypted = EncryptionHelper.getEncrypter(uiKey).doFinal(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
            return Base32.toBase32String((byte[])encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt.", e);
        }
    }

    private static String decryptWithKey(String key, byte[] encrypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return new String(EncryptionHelper.getDecrypter(key).doFinal(encrypted), StandardCharsets.UTF_8);
    }

    private static String generateRandomKey() {
        SecureRandom rnd = new SecureRandom();
        byte[] keyBytes = new byte[16];
        rnd.nextBytes(keyBytes);
        return Base64.getEncoder().encodeToString(keyBytes);
    }

    private static SecretKey generateSecret(String key) {
        return new SecretKeySpec(Base64.getDecoder().decode(key), AES_ENCRYPTION_SCHEME);
    }

    private static Cipher getDecrypter(String key) throws InvalidKeyException {
        SecretKey secretKey = EncryptionHelper.generateSecret(key);
        Cipher decrypter = threadLocalDecrypter.get();
        decrypter.init(2, secretKey);
        return decrypter;
    }

    private static Cipher getEncrypter(String key) throws InvalidKeyException {
        SecretKey secretKey = EncryptionHelper.generateSecret(key);
        Cipher encrypter = threadLocalEncrypter.get();
        encrypter.init(1, secretKey);
        return encrypter;
    }
}

