/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Scope {
    private static final String NONE_SCOPE = "None";
    private final String name;

    public Scope() {
        this.name = NONE_SCOPE;
    }

    public Scope(String name) {
        this.name = StringUtils.capitalize(StringUtils.trim(name));
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return StringUtils.isBlank(this.name) || this.name.equals(NONE_SCOPE);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return StringUtils.equals(this.toString(), other.toString());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

