/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.encryption;

import java.security.SecureRandom;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class EncryptionKeyPair {
    private static final int AES_256_KEY_LENGTH = 256;
    private static final int IV_LENGTH = 128;
    private byte[] secretKey;
    private byte[] iv;

    public EncryptionKeyPair() {
        this.secretKey = EncryptionKeyPair.generateRandomKey(256);
        this.iv = EncryptionKeyPair.generateRandomKey(128);
    }

    public EncryptionKeyPair(String secretKey, String Iv) {
        if (StringUtils.isNotBlank(secretKey)) {
            this.secretKey = Base64.getDecoder().decode(secretKey);
        }
        if (StringUtils.isNotBlank(Iv)) {
            this.iv = Base64.getDecoder().decode(Iv);
        }
    }

    private static byte[] generateRandomKey(int lengthInBits) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] key = new byte[lengthInBits / 8];
        secureRandom.nextBytes(key);
        return key;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public String getStringSecretKey() {
        return Base64.getEncoder().encodeToString(this.secretKey);
    }

    public byte[] getIv() {
        return this.iv;
    }

    public String getStringIv() {
        return Base64.getEncoder().encodeToString(this.iv);
    }

    public boolean isEmpty() {
        return this.secretKey == null || this.secretKey.length == 0 || this.iv == null || this.iv.length == 0;
    }
}

