/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import com.google.common.collect.ArrayListMultimap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.extractor.UrlUtils;

public abstract class DeploymentUrlUtils {
    public static String getDeploymentUrl(String artifactoryUrl, Properties properties) throws UnsupportedEncodingException {
        Map<Object, Object> filteredProperties = CommonUtils.filterMapKeys(properties, input -> ((String)input).startsWith("deploy."));
        StringBuilder deploymentUrl = new StringBuilder(artifactoryUrl);
        Set<Map.Entry<Object, Object>> propertyEntries = filteredProperties.entrySet();
        for (Map.Entry<Object, Object> propertyEntry : propertyEntries) {
            String key = StringUtils.removeStart((String)propertyEntry.getKey(), "deploy.");
            deploymentUrl.append(";").append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode((String)propertyEntry.getValue(), "UTF-8"));
        }
        return deploymentUrl.toString();
    }

    public static String encodePath(String unescaped) {
        int index = unescaped.indexOf(";");
        String path = unescaped;
        String matrixParams = null;
        if (index != -1) {
            path = unescaped.substring(0, index);
            matrixParams = index == unescaped.length() - 1 ? "" : unescaped.substring(index + 1);
        }
        Object[] split = StringUtils.split(path, "/");
        for (int i = 0; i < split.length; ++i) {
            split[i] = UrlUtils.encodeUrlPathPart((String)split[i]);
        }
        String escaped = StringUtils.join(split, "/");
        if (StringUtils.isNotBlank(matrixParams)) {
            escaped = escaped + ";" + matrixParams;
        }
        return escaped;
    }

    public static String buildMatrixParamsString(ArrayListMultimap<String, String> matrixParams, boolean encodeProperties) throws UnsupportedEncodingException {
        StringBuilder matrix = new StringBuilder();
        if (matrixParams != null && !matrixParams.isEmpty()) {
            for (String propertyKey : matrixParams.keySet()) {
                for (String multiPropertyValue : matrixParams.get((Object)propertyKey)) {
                    if (multiPropertyValue == null) continue;
                    for (String propertyValue : multiPropertyValue.split(",")) {
                        propertyValue = propertyValue.trim();
                        matrix.append(";").append(encodeProperties ? DeploymentUrlUtils.encode(propertyKey) : propertyKey).append("=").append(encodeProperties ? DeploymentUrlUtils.encode(propertyValue) : propertyValue);
                    }
                }
            }
        }
        return matrix.toString();
    }

    private static String encode(String s2) throws UnsupportedEncodingException {
        if (s2 != null) {
            return URLEncoder.encode(s2, "UTF-8");
        }
        return null;
    }
}

