/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.distribution.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.request.DistributeReleaseBundleRequest;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.response.DistributeReleaseBundleResponse;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.response.DistributionStatusResponse;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.services.GetDistributionStatus;
import org.jfrog.build.extractor.clientConfiguration.util.JsonUtils;

public class DistributeReleaseBundle
extends JFrogService<DistributeReleaseBundleResponse> {
    static final String DISTRIBUTE_RELEASE_BUNDLE_ENDPOINT = "api/v1/distribution";
    static final int DEFAULT_SYNC_SLEEP_INTERVAL = 10;
    static final int DEFAULT_MAX_WAIT_MINUTES = 60;
    private final DistributeReleaseBundleRequest request;
    private final String version;
    private final boolean sync;
    private final String name;

    public DistributeReleaseBundle(String name, String version, boolean sync, DistributeReleaseBundleRequest request, Log log) {
        super(log);
        this.sync = sync;
        this.name = name;
        this.version = version;
        this.request = request;
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
        if (this.request == null) {
            throw new IOException("DistributeReleaseBundleRequest parameter is mandatory");
        }
        if (StringUtils.isBlank(this.name)) {
            throw new IOException("Release bundle name is mandatory");
        }
        if (StringUtils.isBlank(this.version)) {
            throw new IOException("Release bundle version is mandatory");
        }
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        HttpPost request = new HttpPost(String.format("%s/%s/%s", DISTRIBUTE_RELEASE_BUNDLE_ENDPOINT, this.name, this.version));
        request.setHeader("Accept", " application/json");
        StringEntity stringEntity = new StringEntity(JsonUtils.toJsonString(this.request));
        stringEntity.setContentType("application/json");
        request.setEntity(stringEntity);
        return request;
    }

    @Override
    public DistributeReleaseBundleResponse execute(JFrogHttpClient client) throws IOException {
        this.log.info(this.request.isDryRun() ? "[Dry run] " : "Distributing " + this.name + " / " + this.version);
        super.execute(client);
        if (this.sync && !this.request.isDryRun()) {
            this.waitForDistribution(client);
        }
        return (DistributeReleaseBundleResponse)this.result;
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper().readValue(stream, DistributeReleaseBundleResponse.class);
        this.log.debug("Distribution response: " + this.getStatusCode());
        this.log.debug("Response: " + JsonUtils.toJsonString(this.result));
    }

    private void waitForDistribution(JFrogHttpClient client) throws IOException {
        String trackerId = ((DistributeReleaseBundleResponse)this.result).getTrackerId();
        GetDistributionStatus getDistributionStatusService = new GetDistributionStatus(this.name, this.version, trackerId, this.log);
        for (int timeElapsed = 0; timeElapsed < 3600; timeElapsed += 10) {
            DistributionStatusResponse statusResponse;
            if (timeElapsed % 60 == 0) {
                this.log.info(String.format("Sync: Distributing %s/%s...", this.name, this.version));
            }
            if ((statusResponse = (DistributionStatusResponse)getDistributionStatusService.execute(client)).getStatus().equalsIgnoreCase("Failed")) {
                throw new IOException("JFrog service failed. Received " + this.statusCode + ": " + JsonUtils.toJsonString(statusResponse));
            }
            if (statusResponse.getStatus().equalsIgnoreCase("Completed")) {
                this.log.info("Distribution Completed!");
                return;
            }
            try {
                TimeUnit.SECONDS.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                throw new IOException("Fail to wait for Distribution sync", e);
            }
        }
        throw new IOException("Timeout for sync distribution");
    }
}

