/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.Header;
import org.jfrog.build.api.dependency.BuildPatternArtifacts;
import org.jfrog.build.api.dependency.BuildPatternArtifactsRequest;
import org.jfrog.build.api.dependency.PatternResultFileSet;
import org.jfrog.build.api.dependency.PropertySearchResult;
import org.jfrog.build.api.release.Distribution;
import org.jfrog.build.api.release.Promotion;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.DownloadResponse;
import org.jfrog.build.client.ItemLastModified;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.BuildRetention;
import org.jfrog.build.extractor.clientConfiguration.client.ManagerBase;
import org.jfrog.build.extractor.clientConfiguration.client.RepositoryType;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.CheckRepositoryType;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.CreateRepository;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.DeleteBuilds;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.DeleteProperties;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.DeleteRepository;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.DeleteRepositoryContent;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.DistributeBuild;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.Download;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.DownloadHeaders;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.DownloadToFile;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.ExecuteUserPlugin;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.GetAllBuildNumbers;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.GetBuildInfo;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.GetItemLastModified;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.GetNpmAuth;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.GetRepositoriesKeys;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.GetStagingStrategy;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.GetUserPluginInfo;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.IsRepositoryExist;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.PromotionUserPlugin;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.PublishBuildInfo;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.ReportUsage;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.RetrievePatternArtifacts;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.ScanBuild;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.SearchArtifactsByAql;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.SearchArtifactsByPattern;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.SearchArtifactsByProperties;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.SendBuildRetention;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.SendModuleInfo;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.SetProperties;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.StageBuild;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.UpdateFileProperty;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.Upload;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.Version;
import org.jfrog.build.extractor.clientConfiguration.client.response.GetAllBuildNumbersResponse;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.AqlHelper;
import org.jfrog.build.extractor.usageReport.UsageReporter;

public class ArtifactoryManager
extends ManagerBase {
    public ArtifactoryManager(String artifactoryUrl, String username, String password, String accessToken, Log log) {
        super(artifactoryUrl, username, password, accessToken, log);
    }

    public ArtifactoryManager(String artifactoryUrl, String username, String password, Log log) {
        super(artifactoryUrl, username, password, "", log);
    }

    public ArtifactoryManager(String artifactoryUrl, String accessToken, Log log) {
        super(artifactoryUrl, "", "", accessToken, log);
    }

    public ArtifactoryManager(String artifactoryUrl, Log log) {
        super(artifactoryUrl, "", "", "", log);
    }

    public boolean isLocalRepo(String repositoryKey) throws IOException {
        CheckRepositoryType checkRepositoryTypeService = new CheckRepositoryType(RepositoryType.LOCAL, repositoryKey, this.log);
        return (Boolean)checkRepositoryTypeService.execute(this.jfrogHttpClient);
    }

    public boolean isRemoteRepo(String repositoryKey) throws IOException {
        CheckRepositoryType checkRepositoryTypeService = new CheckRepositoryType(RepositoryType.REMOTE, repositoryKey, this.log);
        return (Boolean)checkRepositoryTypeService.execute(this.jfrogHttpClient);
    }

    public void deleteProperties(String relativePath, String properties) throws IOException {
        DeleteProperties deletePropertiesService = new DeleteProperties(relativePath, properties, this.log);
        deletePropertiesService.execute(this.jfrogHttpClient);
    }

    public void setProperties(String relativePath, String properties, boolean encodeProperties) throws IOException {
        SetProperties setPropertiesService = new SetProperties(relativePath, properties, encodeProperties, this.log);
        setPropertiesService.execute(this.jfrogHttpClient);
    }

    public void setProperties(String relativePath, ArrayListMultimap<String, String> properties, boolean encodeProperties) throws IOException {
        SetProperties setPropertiesService = new SetProperties(relativePath, properties, encodeProperties, this.log);
        setPropertiesService.execute(this.jfrogHttpClient);
    }

    public void distributeBuild(String buildName, String buildNumber, Distribution promotion) throws IOException {
        DistributeBuild distributeBuildService = new DistributeBuild(buildName, buildNumber, promotion, this.log);
        distributeBuildService.execute(this.jfrogHttpClient);
    }

    public DownloadResponse download(String downloadFrom) throws IOException {
        return this.download(downloadFrom, null);
    }

    public DownloadResponse download(String downloadFrom, Map<String, String> headers) throws IOException {
        Download downloadService = new Download(downloadFrom, headers, this.log);
        return (DownloadResponse)downloadService.execute(this.jfrogHttpClient);
    }

    public String downloadHeader(String downloadFrom, String headerName) throws IOException {
        Header[] headers = this.downloadHeaders(downloadFrom);
        if (headers != null) {
            for (Header header : headers) {
                if (!header.getName().equals(headerName)) continue;
                return header.getValue();
            }
        }
        return "";
    }

    public Header[] downloadHeaders(String downloadFrom) throws IOException {
        return this.downloadHeaders(downloadFrom, null);
    }

    public Header[] downloadHeaders(String downloadFrom, Map<String, String> headers) throws IOException {
        DownloadHeaders downloadHeadersService = new DownloadHeaders(downloadFrom, headers, this.log);
        return (Header[])downloadHeadersService.execute(this.jfrogHttpClient);
    }

    public File downloadToFile(String downloadFrom, String downloadTo) throws IOException {
        return this.downloadToFile(downloadFrom, downloadTo, null);
    }

    public File downloadToFile(String downloadFrom, String downloadTo, Map<String, String> headers) throws IOException {
        DownloadToFile downloadToFileService = new DownloadToFile(downloadFrom, downloadTo, headers, this.log);
        return (File)downloadToFileService.execute(this.jfrogHttpClient);
    }

    public void executeUserPlugin(String executionName, Map<String, String> requestParams) throws IOException {
        ExecuteUserPlugin executeUserPluginService = new ExecuteUserPlugin(executionName, requestParams, this.log);
        executeUserPluginService.execute(this.jfrogHttpClient);
    }

    public void promotionUserPlugin(String promotionName, String buildName, String buildNumber, Map<String, String> requestParams) throws IOException {
        PromotionUserPlugin promotionUserPlugin = new PromotionUserPlugin(promotionName, buildName, buildNumber, requestParams, this.log);
        promotionUserPlugin.execute(this.jfrogHttpClient);
    }

    public ItemLastModified getItemLastModified(String path) throws IOException {
        GetItemLastModified getItemLastModifiedService = new GetItemLastModified(path, this.log);
        return (ItemLastModified)getItemLastModifiedService.execute(this.jfrogHttpClient);
    }

    public Properties getNpmAuth() throws IOException {
        GetNpmAuth getNpmAuthService = new GetNpmAuth(this.log);
        return (Properties)getNpmAuthService.execute(this.jfrogHttpClient);
    }

    @Override
    public ArtifactoryVersion getVersion() throws IOException {
        Version versionService = new Version(this.log);
        return (ArtifactoryVersion)versionService.execute(this.jfrogHttpClient);
    }

    public void publishBuildInfo(BuildInfo buildInfo, String platformUrl) throws IOException {
        PublishBuildInfo publishBuildInfoService = new PublishBuildInfo(buildInfo, platformUrl, this.log);
        publishBuildInfoService.execute(this.jfrogHttpClient);
    }

    public void sendModuleInfo(BuildInfo buildInfo) throws IOException {
        SendModuleInfo sendModuleInfoService = new SendModuleInfo(buildInfo, this.log);
        sendModuleInfoService.execute(this.jfrogHttpClient);
    }

    public GetAllBuildNumbersResponse getAllBuildNumbers(String buildName, String project) throws IOException {
        GetAllBuildNumbers getAllBuildNumbersService = new GetAllBuildNumbers(buildName, project, this.log);
        return (GetAllBuildNumbersResponse)getAllBuildNumbersService.execute(this.jfrogHttpClient);
    }

    public void deleteBuilds(String buildName, String project, boolean deleteArtifacts) throws IOException {
        DeleteBuilds deleteBuildsService = new DeleteBuilds(buildName, project, deleteArtifacts, this.log);
        deleteBuildsService.execute(this.jfrogHttpClient);
    }

    public void deleteBuilds(String buildName, String project, boolean deleteArtifacts, String ... buildNumbers) throws IOException {
        DeleteBuilds deleteBuildsService = new DeleteBuilds(buildName, project, buildNumbers, deleteArtifacts, this.log);
        deleteBuildsService.execute(this.jfrogHttpClient);
    }

    public BuildInfo getBuildInfo(String buildName, String buildNumber, String project) throws IOException {
        if (AqlHelper.isBuildLatestType(buildNumber) && (buildNumber = this.getLatestBuildNumber(buildName, buildNumber, project)) == null) {
            return null;
        }
        GetBuildInfo getBuildInfoService = new GetBuildInfo(buildName, buildNumber, project, this.log);
        return (BuildInfo)getBuildInfoService.execute(this.jfrogHttpClient);
    }

    public List<String> getLocalRepositoriesKeys() throws IOException {
        GetRepositoriesKeys getLocalRepositoriesKeysService = new GetRepositoriesKeys(RepositoryType.LOCAL, this.log);
        return (List)getLocalRepositoriesKeysService.execute(this.jfrogHttpClient);
    }

    public List<String> getRemoteRepositoriesKeys() throws IOException {
        GetRepositoriesKeys getRemoteRepositoriesKeysService = new GetRepositoriesKeys(RepositoryType.REMOTE, this.log);
        return (List)getRemoteRepositoriesKeysService.execute(this.jfrogHttpClient);
    }

    public List<String> getVirtualRepositoriesKeys() throws IOException {
        GetRepositoriesKeys getVirtualRepositoriesKeysService = new GetRepositoriesKeys(RepositoryType.VIRTUAL, this.log);
        return (List)getVirtualRepositoriesKeysService.execute(this.jfrogHttpClient);
    }

    public List<String> getFederatedRepositoriesKeys() throws IOException {
        GetRepositoriesKeys getFederatedRepositoriesKeysService = new GetRepositoriesKeys(RepositoryType.FEDERATED, this.log);
        return (List)getFederatedRepositoriesKeysService.execute(this.jfrogHttpClient);
    }

    public Map getStagingStrategy(String strategyName, String buildName, Map<String, String> requestParams) throws IOException {
        GetStagingStrategy getStagingStrategyService = new GetStagingStrategy(strategyName, buildName, requestParams, this.log);
        return (Map)getStagingStrategyService.execute(this.jfrogHttpClient);
    }

    public Map<String, List<Map>> getUserPluginInfo() throws IOException {
        GetUserPluginInfo getUserPluginInfoService = new GetUserPluginInfo(this.log);
        return (Map)getUserPluginInfoService.execute(this.jfrogHttpClient);
    }

    public boolean isRepositoryExist(String repositoryKey) throws IOException {
        IsRepositoryExist IsRepositoryExistService = new IsRepositoryExist(repositoryKey, this.log);
        return (Boolean)IsRepositoryExistService.execute(this.jfrogHttpClient);
    }

    public void reportUsage(UsageReporter usageReporter) throws IOException {
        ReportUsage reportUsageService = new ReportUsage(usageReporter, this.log);
        reportUsageService.execute(this.jfrogHttpClient);
    }

    public List<BuildPatternArtifacts> retrievePatternArtifacts(List<BuildPatternArtifactsRequest> requests) throws IOException {
        RetrievePatternArtifacts retrievePatternArtifactsService = new RetrievePatternArtifacts(requests, this.log);
        return (List)retrievePatternArtifactsService.execute(this.jfrogHttpClient);
    }

    public ArtifactoryXrayResponse scanBuild(String buildName, String buildNumber, String project, String context) throws IOException {
        this.setConnectionTimeout(90);
        ScanBuild scanBuildService = new ScanBuild(buildName, buildNumber, project, context, this.log);
        return scanBuildService.execute(this.jfrogHttpClient);
    }

    public AqlSearchResult searchArtifactsByAql(String aql) throws IOException {
        SearchArtifactsByAql searchArtifactsByAqlService = new SearchArtifactsByAql(aql, this.log);
        return (AqlSearchResult)searchArtifactsByAqlService.execute(this.jfrogHttpClient);
    }

    public PatternResultFileSet searchArtifactsByPattern(String pattern) throws IOException {
        SearchArtifactsByPattern searchArtifactsByPatternService = new SearchArtifactsByPattern(pattern, this.log);
        return (PatternResultFileSet)searchArtifactsByPatternService.execute(this.jfrogHttpClient);
    }

    public PropertySearchResult searchArtifactsByProperties(String properties) throws IOException {
        SearchArtifactsByProperties searchArtifactsByPropertiesService = new SearchArtifactsByProperties(properties, this.log);
        return (PropertySearchResult)searchArtifactsByPropertiesService.execute(this.jfrogHttpClient);
    }

    public void sendBuildRetention(BuildRetention buildRetention, String buildName, String project, boolean async) throws IOException {
        SendBuildRetention sendBuildRetentionService = new SendBuildRetention(buildRetention, buildName, project, async, this.log);
        sendBuildRetentionService.execute(this.jfrogHttpClient);
    }

    public void stageBuild(String buildName, String buildNumber, String project, Promotion promotion) throws IOException {
        StageBuild stageBuildService = new StageBuild(buildName, buildNumber, project, promotion, this.log);
        stageBuildService.execute(this.jfrogHttpClient);
    }

    public void updateFileProperty(String itemPath, String properties) throws IOException {
        UpdateFileProperty updateFilePropertyService = new UpdateFileProperty(itemPath, properties, this.log);
        updateFilePropertyService.execute(this.jfrogHttpClient);
    }

    public ArtifactoryUploadResponse upload(DeployDetails details) throws IOException {
        return this.upload(details, null, null);
    }

    public ArtifactoryUploadResponse upload(DeployDetails details, String logPrefix) throws IOException {
        return this.upload(details, logPrefix, null);
    }

    public ArtifactoryUploadResponse upload(DeployDetails details, String logPrefix, Integer minChecksumDeploySizeKb) throws IOException {
        Upload uploadService = new Upload(details, logPrefix, minChecksumDeploySizeKb, this.log);
        return uploadService.execute(this.jfrogHttpClient);
    }

    public void deleteRepository(String repository) throws IOException {
        DeleteRepository deleteRepositoryService = new DeleteRepository(repository, this.log);
        deleteRepositoryService.execute(this.jfrogHttpClient);
    }

    public void deleteRepositoryContent(String repository) throws IOException {
        DeleteRepositoryContent deleteRepositoryContentService = new DeleteRepositoryContent(repository, this.log);
        deleteRepositoryContentService.execute(this.jfrogHttpClient);
    }

    public void createRepository(String repository, String repositoryJsonConfig) throws IOException {
        CreateRepository createRepository = new CreateRepository(repository, repositoryJsonConfig, this.log);
        createRepository.execute(this.jfrogHttpClient);
    }

    public String getLatestBuildNumber(String buildName, String latestType, String project) throws IOException {
        String trimmedLatestType = latestType.trim();
        if (!AqlHelper.isBuildLatestType(latestType)) {
            this.log.warn("GetLatestBuildNumber accepts only two latest types: LATEST or LAST_RELEASE. Got: " + trimmedLatestType);
            return null;
        }
        Version versionService = new Version(this.log);
        if (((ArtifactoryVersion)versionService.execute(this.jfrogHttpClient)).isOSS()) {
            throw new IllegalArgumentException(String.format("%s is not supported in Artifactory OSS.", latestType));
        }
        ArrayList<BuildPatternArtifactsRequest> artifactsRequest = Lists.newArrayList();
        artifactsRequest.add(new BuildPatternArtifactsRequest(buildName, latestType, project));
        List<BuildPatternArtifacts> artifactsResponses = this.retrievePatternArtifacts(artifactsRequest);
        if (artifactsResponses.get(0) != null) {
            return artifactsResponses.get(0).getBuildNumber();
        }
        return null;
    }
}

