/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.client.Version;

public abstract class ManagerBase
implements AutoCloseable {
    protected final JFrogHttpClient jfrogHttpClient;
    protected final Log log;

    protected ManagerBase(String url, String username, String password, String accessToken, Log logger) {
        this.jfrogHttpClient = StringUtils.isNotEmpty(accessToken) ? new JFrogHttpClient(url, accessToken, logger) : new JFrogHttpClient(url, username, password, logger);
        this.log = logger;
    }

    public abstract Version getVersion() throws IOException;

    public void setConnectionTimeout(int connectionTimeout) {
        this.jfrogHttpClient.setConnectionTimeout(connectionTimeout);
    }

    public void setConnectionRetries(int connectionRetries) {
        this.jfrogHttpClient.setConnectionRetries(connectionRetries);
    }

    public void setProxyConfiguration(String host, int port) {
        this.jfrogHttpClient.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.jfrogHttpClient.setProxyConfiguration(host, port, username, password);
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.jfrogHttpClient.getProxyConfiguration();
    }

    public void setProxyConfiguration(ProxyConfiguration proxy) {
        this.jfrogHttpClient.setProxyConfiguration(proxy.host, proxy.port, proxy.username, proxy.password);
    }

    public void setLog(Log log) {
        this.jfrogHttpClient.getHttpClient().setLog(log);
    }

    public void setInsecureTls(boolean insecureTls) {
        this.jfrogHttpClient.setInsecureTls(insecureTls);
    }

    public void setSslContext(SSLContext sslContext) {
        this.jfrogHttpClient.setSslContext(sslContext);
    }

    public String getUrl() {
        return this.jfrogHttpClient.getUrl();
    }

    @Override
    public void close() {
        if (this.jfrogHttpClient != null) {
            this.jfrogHttpClient.close();
        }
    }
}

